// NetConn library test

#include "pp/OS_Port.h"
#include "pp/NetConn.h"
#include "pp/CSC.h"
#include "pp/CSCProtocol.h"
#include "pp/CSCConnect.h"
#include "pp/RDM.h"
#include "pp/RDM_Database.h"
#include "pp/Session.h"

#include <stdio.h>
#include "assert.h"

int verbose = 0;
int connectionCount = 0;
#define LOCAL_HOST 0x7F000001

// Our Protocols

class CRDMProtocol : public CCSCProtocol
{
public:
	CRDMProtocol() : CCSCProtocol("RDM","SSL","1","1","None","CSC") {}

	virtual void AcceptClientSocket( CSession *pSession, CNetConn *pNetConn, int ipAddress, int tcpPort )
	{
		connectionCount++;
		printf("RDM Connection %0X8, %04d\n",ipAddress,tcpPort);
		OS_Sleep(3000);
		pNetConn->Shutdown();
		pSession->Release();
	}
};

class CRDMEventProtocol : public CCSCProtocol
{
public:
	CRDMEventProtocol() : CCSCProtocol("RDMEvent","SSL","1","1","None","CSC") {}

	virtual void AcceptClientSocket( CSession *pSession, CNetConn *pNetConn, int ipAddress, int tcpPort )
	{
		connectionCount++;
		printf("RDMEvent Connection %0X8, %04d\n",ipAddress,tcpPort);
		OS_Sleep(3000);
		pNetConn->Shutdown();
		pSession->Release();
	}
};

CRDM_Secure_SXDB	rdm_db;
CRDM				rdm(&rdm_db);
CRDM_Database		gDatabaseService( &rdm );
CSessionManager		gSessionManager( &rdm );

int main(int argc, char *argv[])
{
	int					result;
	char			*	pCSCInfo;
	CCSC				csc(&gSessionManager);
	CRDMProtocol		rdmProtocol;
	CRDMEventProtocol	rdmEventProtocol;

	// Start CSC

	result = csc.Initialize();
	assert( result >= 0);
	csc.SetDeviceDescription( "IP-Reach", "DKX", "CSC Test Device", "1", "MyTestDevice", NULL );
	csc.AddProtocol( &rdmProtocol );
	csc.AddProtocol( &rdmEventProtocol );

	CCSCConnect			cscConnect;		// NOTE: must create after csc.Initialize because of SSL library initialization

	// Connect to RDM

	result = cscConnect.Connect( LOCAL_HOST, 5000, NULL);
	assert( result >= 0);
	pCSCInfo = cscConnect.GetCSCInfo();
	assert(pCSCInfo != NULL);
	delete pCSCInfo;
	result = cscConnect.StartNewCSCSession("RDM","admin","raritan","SSL","CSC");
	assert( result >= 0);
	OS_Sleep(1000);
	assert(connectionCount == 1);
	fflush(stdout);

	// Connect to RDMEvent

	result = cscConnect.Connect( LOCAL_HOST, 5000, NULL);
	assert( result >= 0);
	pCSCInfo = cscConnect.GetCSCInfo();
	assert(pCSCInfo != NULL);
	delete pCSCInfo;
	result = cscConnect.StartNewCSCSession("RDMEvent","admin","raritan","SSL","CSC");
	assert( result >= 0);
	OS_Sleep(1000);
	assert(connectionCount == 2);
	fflush(stdout);

	// CSC_Discovery

	char * p = Query_CSC_Info(LOCAL_HOST,5000,10);
	assert(p != NULL);
	delete [] p;

	printf("PASS\n");

	return 0;
}




bool CSC_AuthenticateUser
(
	const char                *name,
	const char                *password,
	DWORD               ipAddress,
	CUserObject 	**	ppUserObject
)
{
	printf("Authenticate %s %s\n",name,password);
	*ppUserObject = NULL;
	return true;
}




//--------------------------------------------------------------------------------
//
	char *								// Ptr to the string
	RDM_RDMTimeToString
	(
		RDM_TIME	*pST,				// Ptr to the SYSTEMTIME struct
		char		*pString			// Where to put the string
	)
//
//	Converts a system time to an RDM date & time string.
//
//------------------------------------------------------------------------------//
{
	// Utility function, no need to change this for porting

	sprintf(pString,"%04d-%02d-%02d %02d:%02d:%02d",
				(int) pST->year,
				(int) pST->month,
				(int) pST->day,
				(int) pST->hour,
				(int) pST->minute,
				(int) pST->second
			);

	return pString;
}

//--------------------------------------------------------------------------------
//
	void
	RDM_GetSystemTime
	(
		RDM_TIME	*pRDMTime
	)
//
//	Returns the current UTC time and date in an RDM_TIME structure
//
//------------------------------------------------------------------------------//
{
	// Replace with code to get the current system time and date UTC time

	pRDMTime->year		= 2004;
	pRDMTime->month		= 1;
	pRDMTime->day		= 1;
	pRDMTime->hour		= 0;
	pRDMTime->minute	= 0;
	pRDMTime->second	= 0;
}

//--------------------------------------------------------------------------------
//
	int									// RDM_ERROR
	RDM_SetSystemTime
	(
		RDM_TIME	*pRDMTime
	)
//
//	Sets the system UTC time.
//
//------------------------------------------------------------------------------//
{
	// Replace with code to set the current system time and date UTC time

	return 0;
}

//--------------------------------------------------------------------------------
//
	int									// RDM_ERROR
	RDM_ConvertUTCToLocalTime
	(
		RDM_TIME	*pUTCTime,
		RDM_TIME	*pLocalTime
	)
//
//	Converts from UTC time to Local time
//
//------------------------------------------------------------------------------//
{
	// Replace this with code that converts pUTCTime to the local time zone time
	// in pLocalTime

	pLocalTime = pUTCTime;

	return 0;
}

//---------------------------------------------------------------------------
//
	CSXDB_Node	*					// Ptr to DeviceSettings
	RDM_GetDeviceSettings
	(
	)
//
//	Returns the node ptr /DeviceSettings node where the RDM device settings
//	data will be stored.
//
//---------------------------------------------------------------------------
{
	return NULL;
}

//--------------------------------------------------------------------------------
//
	int									// RDM_ERROR
	RDM_CommitDeviceSetting
	(
	)
//
//	Commits the RDM Database
//
//------------------------------------------------------------------------------//
{
	// Replace with code to save the device settings branch of the database

	return 0;
}

//--------------------------------------------------------------------------------
//
	int									// RDM_ERROR
	RDM_ShutDown
	(
	)
//
//	Shuts down the system
//
//------------------------------------------------------------------------------//
{
	// Replace with code that shuts down the system

	return RDM_ERROR_FUNCTION_NOT_FOUND;
}

//--------------------------------------------------------------------------------
//
	int									// RDM_ERROR
	RDM_Restart
	(
	)
//
//	Restarts the system
//
//------------------------------------------------------------------------------//
{
	// Replace with code that Restart the system

	return RDM_ERROR_FUNCTION_NOT_FOUND;
}

//--------------------------------------------------------------------------------
//
	int									// RDM_ERROR
	RDM_CloseAllVideoStreams
	(
	)
//
//	Closes all video streams
//
//------------------------------------------------------------------------------//
{
	// Replace with code that closes all video streams
	// Probably only for IP_Reach

	return RDM_ERROR_FUNCTION_NOT_FOUND;
}

//--------------------------------------------------------------------------------
//
    char *                          // returns the unique id
    RDM_CreateUniqueID
    (
        char* pPrefix,
        int   index,
        char* pOutput
    )
//
//  Return unique id
//
//------------------------------------------------------------------------------//
{
    if (pOutput != NULL)
    {
        //memset ( pOutput, 0, RDM_MAX_ID );
        //sprintf ( pOutput, "%s%d_%s", pPrefix, index, idgen->IDPrefix() );
		sprintf(pOutput,"%s_%d",pPrefix,index);
    }

    return pOutput;
}

//--------------------------------------------------------------------------------
//
    void *
    RDM_GetCCUserObject
    (

    )
//
// return CCUserObject
//
//--------------------------------------------------------------------------------
{
        return NULL;
}

//--------------------------------------------------------------------------------
//
    const char *					// Returns ptr to deviceID string or NULL if none
    RDM_GetDeviceID
    (
    )
//
// return deviceID string
//
//--------------------------------------------------------------------------------
{
	return "DeviceID";
}

//--------------------------------------------------------------------------------
//
    bool								//returns true on success, false otherwise.  
    DEP_UpdateSessionHistory 
    (
        const char* pSessionID,
        const char* pLoginTime,
        const char* pLogoutTime,
        const char* pLastResourceUsed,
        const char* pUserID,
        const char* pUserName,
        const char* pGroupID
    )
//
//  Preserves the session history of a local user
//
//--------------------------------------------------------------------------------
{
	return false;
}


