/**	
 *	@file	CSCAccept.h
 *	@brief	This class defines a protocol that can be negotiated by
 * 			CSC. Adding a CCSCAccept class to the CCSC object causes
 * 			A new protocol descriptor to be added the the CSC_Info struct.
 * 			This handler is also called when a new TCP socket requests
 * 			This protocol
 *
 */

#ifndef _CSCAccept_h_
#define _CSCAccept_h_

#include "pp/OS_Port.h"
#include "pp/Session.h"
#include "pp/SXDB_Parse.h"
#include "pp/RDM_Definitions.h"
#include "pp/SXDB_Parse_Table.h"

/*----------------------------------------
 *	Equates
 *--------------------------------------*/

#define	CSC_MAX_PROTOCOL		4

/*----------------------------------------
 *	Data Types
 *--------------------------------------*/

typedef	struct
{
	char	id[RDM_MAX_ID];
	char	encrypt[RDM_MAX_ID];
	char	version[RDM_MAX_ID];
	char	oldestVersion[RDM_MAX_ID];
	char	compression[RDM_MAX_ID];
	char	auth[RDM_MAX_ID];
} CSC_Protocol_Info;

/*----------------------------------------
 *	Function Prototypes
 *--------------------------------------*/

/*----------------------------------------
 *	Forward References
 *--------------------------------------*/

class CCSCInfo;
class CNetConn_Socket;
class CCSCProtocol;

/*----------------------------------------
 *	CNetConn Class
 *--------------------------------------*/

class	CCSCAccept
{
public:

	CCSCAccept( CSessionManager *pSessionManager, CCSCInfo *pCSCInfo);

	virtual
	~CCSCAccept();

	inline
	void
	SetSocket( CNetConn_Socket * pNetConn)
	{
		this->m_pNetConn = pNetConn;
	}

	inline
	char *
	GetProtocolName( )
	{
		return protocolInfo.id;
	}

	inline
	char *
	GetEncryptionName( )
	{
		return protocolInfo.encrypt;
	}

	inline
	char *
	GetAuthenticationName( )
	{
		return protocolInfo.auth;
	}

	inline
	char *
	GetSessionID( )
	{
		if (referralSession)
			return sessionID;
		else
			return NULL;
	}

	inline
	CUserObject *
	GetUserObjectID( )
	{
		return pUserObject;
	}

	inline
	CCSCProtocol *
	GetProtocol( )
	{
		return pProtocol;
	}

	inline
    void
    SetClientIP( DWORD newIpAddress )
	{
       ipAddress = newIpAddress;
	}

	int									// <0 = error
	NegotiateProtocol
	(
		int		*pBytesSent				// Optional parameter used to return
										// the number of bytes sent if CSC
										// failed
	);

	int									// <0 = error, 0 = native auth, 1 = good
	Authenticate
	(
	);

	void
	SetDeviceDescription
	(
		const char	*pType,					// Ptr to the type name
		const char	*pModel,				// Ptr to the model name
		const char	*pProductName,			// Ptr to the product name
		const char	*pVersion,				// Ptr to the version number
		const char	*pName,					// Ptr to the device name
		const char	*pCluster,				// Ptr to the CC cluster name (Can be NULL)
		const char	*pExtra					// Ptr to extra XML data to be
										// included into the description
										// CAn be NULL if no extra data
	);

	// --------------------------------
	// Data
	// --------------------------------

private:

	CNetConn_Socket	*m_pNetConn;		// NetConn used for IO
	CSXDB_Parse		dbParser;			// Used to parse incoming messages

	char			sessionID[RDM_MAX_ID];// The unique session ID
	int				referralSession;	// !0 = this is a referral session
	char			protocolID[RDM_MAX_ID];// The protocol to be used
	CUserObject		*pUserObject;		// Store the User object create during authentication
	CCSCProtocol  *	pProtocol;			// Ptr to the negociated protocol object
	CSC_Protocol_Info	protocolInfo;	// The info about the select protocol
    DWORD ipAddress;
	CCSCInfo		*pCSCInfo;			// Ptr to the CSC info object
	CSessionManager *pSessionManager;	// Access to the session manager

	int									// <0 = error, 1 = good
	CSC_Authenticate
	(
	);

	int									// <0 = error, 1 = good
	Referral_Authenticate
	(
	);

	int									// <0 = error
	CSC_Test
	(
		const char *pKey					// Key in Base 64
	);

	int								// 0 = no error
	GetMessage
	(
		SXDB_PT		*parseTable,	// PT Parse table for the message
		void		*pStruct,		// Where to put the data
		SXDB_PT		*altParseTable = NULL,	// Alternte PT Parse table for the message
		void		*pAltStruct = NULL		// Where to put the Alternate data
	);

	int								// 0 = no error
	WriteMessage
	(
		const char	*pData				// Ptr to the message
	);
};

#endif // _CSCAccept_H_


