/*----------------------------------------------------------------------------

	CSCConnect.h

	Copyright (c) 2000, Raritan Computer, Inc.

	Class for connecting to CSC protocols

----------------------------------------------------------------------------*/

#ifndef _CSCConnect_H_
#define _CSCConnect_H_

#include "pp/OS_Port.h"

//----------------------------------------
//				Data Types
//----------------------------------------

//----------------------------------------
//				Function Prototypes
//----------------------------------------

	char *								// Ptr to CSC_Info document
	Query_CSC_Info
	(
		int			ipAddress,			// The IP Address
		short		tcpPort,			// Which port (0 = default = 5000)
		int			seconds				// # of seconds to wait (0 = default = 10)
	);

//----------------------------------------
//				Static Data
//----------------------------------------

class CNetConn;
class CNetConn_SSL_CTX;

//----------------------------------------
//				Class
//----------------------------------------

class CCSCConnect
{
public:

	CCSCConnect();
	virtual ~CCSCConnect();

	int									// 0= connected <0 = error
	Connect
	(
		int			ipAddress,
		short		tcpPort,
		const char	*	connectionID
	);

	char *								// Ptr to CSC_Info document or NULL
	GetCSCInfo
	(
	);

	int									// <0 = error
	StartNewCSCSession
	(
		const char	*	protocol,		// Protocol ID
		const char	*	userName,		// User name
		const char	*	password,		// password
		const char	*	encryption,		// Encryption type
		const char	*	authentication		// Authentication type
	);

	int
	StartReferralCSCSession
	(
		const char	*	protocol,		// Protocol ID
		const char	*	sessionID,		// NULL for new session, or sessionID
		const char	*	sessionKey,		// Must be spcified if seesionID is used
		const char	*	encryption		// Encryption type
	);

	void
	Disconnect
	(
	);

	inline
	int
	IsConnected() {return connected;};

	int									// 0 if no error
	WriteMessage
	(
		const char	*	pMessage		// Message to send
	);

	BOOL								// 0 if no error
	SelectForRead
	(
		int		timeout_in_sec	
	);

	int									// 0 if no error
	ReadMessage
	(
		char	**	pMessage,			// Message to send
		int		maxLength = 0			// Optional max length, 0 = no limit
	);

    int
	Write
	(
		const void	*	pData,			// Ptr to the data to write
		int			count			// # of bytes to write
	);

	int									// 0 if no error
	Read
	(
		void	*		pData,			// Where to put the data
		int			count			// # of bytes to read
	);

private:

	int									// <0 = error
	CSC_Test
	(
		const char *pKey					// Key in Base 64
	);

private:

	int				connected;			// !0 = the socket is connected
	int				isSSL;				// !0 = SSL session running
	int				authenticated;		// !0 = connection authenticated

	CNetConn	  *	netConn;			// The Network connection (CNetConn_Socket or CNetConn_SSL)
	CNetConn_SSL_CTX *sslCtx;			// Our SSL Context
};

#endif //_CSCConnect_H_
