/**	
 *	@file	NetConn_UDP.cpp
 *	@brief	CNetConn derived class for encrypted socket communications
 * 
 * 	Implementation of the CNetConn_UDP class.
 *	Communications channel through a SSL socket
 *
 */

#include	"pp/NetConn_UDP.h"
#include	"assert.h"

/*----------------------------------------
 *	Equates
 *--------------------------------------*/

/*----------------------------------------
 *	Data Types
 *--------------------------------------*/

/*----------------------------------------
 *	Function Prototypes
 *--------------------------------------*/

/*----------------------------------------
 *	static data
 *--------------------------------------*/

/*----------------------------------------
 *	CNetConn_UDP Class
 *--------------------------------------*/

/*  --------------------------------------------------------------------*/
/** Constructors **/

CNetConn_UDP::CNetConn_UDP(int ipAddress, int port)
{
	// Create a new socket

	udpSocket = socket( AF_INET, SOCK_DGRAM, 0 );

	assert(udpSocket != INVALID_SOCKET);

	if (udpSocket == INVALID_SOCKET)
		return;

	// Set the address info

	socketAddress.sin_family = AF_INET;
#ifdef WIN32
	socketAddress.sin_addr.S_un.S_addr = htonl(ipAddress);
#else
	socketAddress.sin_addr.s_addr = htonl(ipAddress);
#endif
	socketAddress.sin_port = htons(port);
}

CNetConn_UDP::~CNetConn_UDP()
{
	if (udpSocket != INVALID_SOCKET)
	{
		closesocket(udpSocket);
	}
}

/*  --------------------------------------------------------------------*/
/** See NetConn_Socket.h **/

int CNetConn_UDP::Write(const void * _pData, int count)
{
	return sendto( udpSocket, _pData, count, 0, (sockaddr *) &socketAddress, sizeof(socketAddress) );
}


