/**	
 *	@file	NetConn_Socket.h
 *	@brief	CNetConn derived class for unencrypted socket communications
 *
 */

#ifndef _NetConn_RC4_h_
#define _NetConn_RC4_h_

#include	"pp/NetConn_Socket.h"

#include <openssl/rsa.h>       /* SSLeay stuff */
#include <openssl/crypto.h>
#include <openssl/x509.h>
#include <openssl/pem.h>
#include <openssl/ssl.h>
#include <openssl/err.h>
#include <openssl/rc4.h>
#include <openssl/evp.h>


/*----------------------------------------
 *	Equates
 *--------------------------------------*/

/*----------------------------------------
 *	Data Types
 *--------------------------------------*/

/*----------------------------------------
 *	Function Prototypes
 *--------------------------------------*/

/*----------------------------------------
 *	Forward References
 *--------------------------------------*/

/*----------------------------------------
 *	CNetConn_RC4 Class
 *--------------------------------------*/

class CNetConn_RC4 : public CNetConn_Socket
{
public:

	CNetConn_RC4();
	CNetConn_RC4( SOCKET s );
	virtual ~CNetConn_RC4();

	/*  --------------------------------------------------------------------*/
	/** 
	 *	@brief	Sets the RC4 key
	 * 
	 *  There are seperate read and write keys. Both must be set.
	 *
	 *	@param	pRC4Key			the RC4 key to use for encryption/decryption
	 *	@param	port			port to connect to
	 *	@return					posix error number
	 */

	void SetRC4WriteKey( RC4_KEY * pRC4Key );
	void SetRC4ReadKey( RC4_KEY * pRC4Key );

	/*  --------------------------------------------------------------------*/
	/** 
	 *	@brief	Write data to the network connection
	 *
	 *	@param	pData			Ptr to the data to write
	 *	@param	count			# of bytes to write
	 *	@return					true = no errors, false = write failed
	 */

	virtual	BOOL Write( const void * pData, int count );

	/*  --------------------------------------------------------------------*/
	/** 
	 *	@brief	Read data from the network connection
	 *
	 *	@param	pData		  	Ptr to the buffer
	 *	@param	count			# of bytes to read
	 *	@return					true = no errors, false = read failed
	 */

	virtual	BOOL Read( void * pData, int count );

protected:
	
	SOCKET		socket;					///< The socket to communicate over
	RC4_KEY		rdRC4Key;				///< The RC4 read key
	RC4_KEY		wrRC4Key;				///< The RC4 write key
	BYTE	*	pEncryptBuffer;			///< Buffer for encrypt out going data
};

#endif // _NetConn_RC4_h_
