/**	
 *	@file	NetConn_SSL.h
 *	@brief	Simple class for listening for client socket connections
 *
 */

#ifndef _TCPListener_h_
#define _TCPListener_h_

#include	"pp/OS_Port.h"

/*----------------------------------------
 *	Equates
 *--------------------------------------*/

/*----------------------------------------
 *	Data Types
 *--------------------------------------*/

/*----------------------------------------
 *	Function Prototypes
 *--------------------------------------*/

/*----------------------------------------
 *	Forward References
 *--------------------------------------*/

/*----------------------------------------
 *	CTCPListener Class
 *--------------------------------------*/

class CTCPListener
{
public:

	/*  --------------------------------------------------------------------*/
	/** 
	 *	@brief	Constructor
	 *	@return					0 = no error
	 * 
	 * 	@param	port			The TCP port # to listen to
	 */

	CTCPListener( int port );
	virtual ~CTCPListener();

	/*  --------------------------------------------------------------------*/
	/** 
	 *	@brief	Initialize the TCP socket and start the listen thread
	 * 
	 *	@return					0 = no error
	 */

	int Initialize( );

	/*  --------------------------------------------------------------------*/
	/** 
	 *	@brief	Stops the listening thread
	 * 
	 *	@return					0 = no error
	 */

	void Shutdown( );

	/*  --------------------------------------------------------------------*/
	/** 
	 *	@brief	Call back function. Called when a new tcp connection has
	 *  been accepted
	 * 
	 *  This function must be over ridden to accept TCP connections.
	 * 
	 * 	@param	s				The socket
	 *  @param	ipAddress		The client IP address
	 *  @param	tcpPort			The client TCP Port
	 */

	virtual void AcceptClientSocket( SOCKET s, int ipAddress, int tcpPort );

	/*  --------------------------------------------------------------------*/
	/** 
	 *	@brief	Closes the socket
	 * 
	 */

	void CloseSocket( SOCKET s );


	void ListenThread( );

protected:
	int			initialized;			// !0 = we are ready to read and write
	SOCKET		listenSocket;			// The socket used to listen for connections
	int			port;					// The TCP port we are listening to
	OS_THREAD	thread;					// Our listen thread

};

#endif // _TCPListener_h_
