/*--------------------------------------------------------------------------------
	OS_PORT.h
	Copyright (c) 2001, Raritan Computer, Inc.
	ClientLib OS porting layer
--------------------------------------------------------------------------------*/

#ifndef		_OS_PORT_H_
#define		_OS_PORT_H_

// Include Port Specific Header File

#ifdef OS_MFC
#include	"OS_MFC.h"
#endif

#ifdef OS_WIN32
#include	"OS_Win32.h"
#endif

#ifdef OS_POSIX
#include	"OS_Posix.h"
#endif

#include <errno.h>

// Make sure the functions are callable from C++

#ifdef __cplusplus
extern "C"
{
#endif

//----------------------------------------
//				Equates
//----------------------------------------


// Thread Attributes (Bit mask)

#define	OS_THREAD_NORMAL			0	// No special attributes
#define	OS_THREAD_MFC				1	// Thread is MFC type

#ifdef OS_POSIX
#define OS_THREAD_DETACHED          2   // detached thread, no need to recycle
#endif

#ifdef OS_WIN32
#define OS_THREAD_DETACHED          OS_THREAD_NORMAL    // Win doesn't have it
#endif

// Event Attributes (Bit Mask)

#define	OS_EVENT_NORMAL				0	// No special attributes

// Critical Section Attributes (Bit Mask)

#define	OS_CRITICAL_SECTION_NORMAL	0	// No special attributes
#define	OS_RWLOCK_NORMAL	0	// No special attributes

// Error Codes

#define	OS_ERROR_TIMEOUT			0xFFFFFFFF

// Misc.

#define	OS_INFINITE					0

//----------------------------------------
//				Data Types
//----------------------------------------

// Opaque Data Types

typedef	void *	OS_THREAD;
typedef	void *	OS_EVENT;
typedef	void *	OS_CRITICAL_SECTION;
typedef void *  OS_RWLOCK;

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				Function Prototypes
//----------------------------------------

	void
	OS_Startup(void);

	void
	OS_Shutdown(void);

	OS_THREAD							// Returns NULL if creation fails
	OS_CreateThread
	(
		void *		pFunction,			// Ptr to the start of the thread
		DWORD		dwAttributes,		// Thread attributes (OS_THREAD_xxx)
		void *		pParam				// Use data passed to the thread function
	);

	DWORD								// The return value of the thread
	OS_DeleteThread
	(
		OS_THREAD	hThread				// HANDLE to the thread
	);

	DWORD								// The return value of the thread
	OS_WaitForThread
	(
		OS_THREAD	hThread				// HANDLE to the thread
	);

	OS_THREAD
	OS_GetCurrentThread(void);

	void
	OS_Sleep
	(
		DWORD	ms						// # of ms to sleep
	);

	OS_EVENT							// Returns NULL if creation fails
	OS_CreateEvent
	(
		DWORD		dwAttributes		// Event attributes (OS_EVENT_xxx)
	);

	void
	OS_DeleteEvent
	(
		OS_THREAD	hOSThread			// HANDLE to the thread
	);

	void
	OS_SetEvent
	(
		OS_THREAD	hOSThread			// HANDLE to the thread
	);

	void
	OS_ResetEvent
	(
    	OS_THREAD	hOSThread			// HANDLE to the thread
	);

	DWORD								// Returns 0 or OS_ERROR_TIMEOUT
	OS_WaitForEvent
	(
		OS_THREAD	hOSThread,			// HANDLE to the thread
		DWORD		timeout				// # of ms to wait for event or OS_INFINITE
	);

	OS_CRITICAL_SECTION					// Returns NULL if creation fails
	OS_CreateCriticalSection
	(
		DWORD		dwAttributes		// Event attributes (OS_CRITICAL_SECTION_xxx)
	);

	void
	OS_DeleteCriticalSection
	(
		OS_CRITICAL_SECTION		hCS		// Handle to the critical section to delete
	);

	void
	OS_EnterCriticalSection
	(
		OS_CRITICAL_SECTION		hCS		// Handle to the critical section to enter
	);

	void
	OS_LeaveCriticalSection
	(
		OS_CRITICAL_SECTION		hCS		// Handle to the critical section to enter
	);

	void *OS_CheckCriticalSection
	(
		OS_CRITICAL_SECTION     hCS     // Handle to the critical section to enter
	);

	DWORD
	OS_GetTickCount(void);

    int 
    OS_GetTimeStamp
    (
        char *buf, 
        const int limit_size
  );

    // Define read/write lock functions

    OS_RWLOCK   
    OS_CreateRWLock
    ( 
        DWORD dwAttributes
    );

    int         
    OS_DeleteRWLock
    (
        OS_RWLOCK  rwlock 
    );

    int         
    OS_ReadLock
    ( 
        OS_RWLOCK  rwlock 
    );

    int         
    OS_TryReadLock
    ( 
        OS_RWLOCK rwlock 
    );

    int         
    OS_ReadUnlock
    ( 
        OS_RWLOCK rwlock 
    );

    int         
    OS_WriteLock
    ( 
        OS_RWLOCK rwlock 
    );

    int         
    OS_TryWriteLock
    ( 
        OS_RWLOCK rwlock 
    );

    int         
    OS_WriteUnlock
    ( 
        OS_RWLOCK rwlock 
    );

    int
    OS_GetLastSocketError(void);



#ifdef OS_POSIX
	int WSAGetLastError(void); // NOTE:: fill in with function to get last socket error
#endif


#define	OS_IsSocketValid(s)			(s != INVALID_SOCKET)
#define	OS_EWOULDBLOCK				WSAEWOULDBLOCK


#ifdef __cplusplus
}	// extern "C"
#endif

#endif // _OS_PORT_H_
