/*--------------------------------------------------------------------------------

	OS_Posix.h

	Copyright (c) 2001, Raritan Computer, Inc.

	ClientLib OS porting layer
	Posix include file

--------------------------------------------------------------------------------*/

#ifndef OS_POSIX
#pragma once
#endif

#include	<stdio.h>
#include	<unistd.h>
#include	<string.h>
#include	<ctype.h>
#include	<sys/types.h>
#include	<sys/resource.h>
#include	<sys/socket.h>
#include	<netinet/in.h>
#include	<netinet/tcp.h>
#include	<arpa/inet.h>
#include	<errno.h>

#define		_OS_POSIX_H
#define		INFINITE				0
#define		stricmp					strcasecmp

// *******************************************
// DEBUG only...replace with real socket.h file
typedef int SOCKET;
/*
#define socket(a,b,c)				0
#define	connect(a,b,c)				0
#define	setsockopt(a,b,c,d,e)		0
#define	recv(a,b,c,d)				0
#define	send(a,b,c,d)				0
#define recvfrom(a,b,c,d,e,f)		0
#define	sendto(a,b,c,d,e,f)			0
#define	select(a,b,c,d,e)			0
#define	gethostbyname(a)			0
#define	AF_NET						0
#define	htons(a)					0
#define	htonl(a)					0
#define	ntohl(a)					0
#define	TCP_NODELAY					0
#define	IPPROTO_TCP					0
#define	AF_INET						0
#define	FD_ZERO(a)					((a)->fd_count = 0)
#define	FD_SET(a,b)					0
struct   in_addr {
    union   {
         struct{
             unsigned  char   s_b1,s_b2,s_b3,s_b4;
        }  S_un_b;
             struct  {
             unsigned  short  s_w1,s_w2;
              }  S_un_w;
               unsigned long  S_addr;
     } S_un;
};
struct sockaddr_in{
    short            sin_family;
    unsigned short      sin_port;
    struct   in_addr      sin_addr;
    char               sin_zero[8];
};
typedef struct fd_set {
  unsigned int    fd_count;                 // how many are SET? 
  SOCKET   fd_array[10];		     // an array of SOCKETs 
} fd_set;

struct timeval {
  long    tv_sec;         // seconds 
  long    tv_usec;        // and microseconds 
};
struct hostent {
  char  *       h_name;
  char  *  * h_aliases;
  short            h_addrtype;
  short            h_length;
  char  *  * h_addr_list;
};
*/
// End of fake Socket.h defines
// *************************************

//----------------------------------------
//				Equates
//----------------------------------------

	// Misc. Windoes Equates

#define	MAX_PATH			255
#define	WINAPI
#define	HRASCONN			int
#define	RASCONNSTATE		int
#define	BI_RGB				0
//#define	SetLastError(a)			printf("SetLastError %d\n", *a);
#define	SetLastError(a)
#define	TRUE				1
#define	FALSE				0
#define	INVALID_SOCKET		-1
#define	closesocket(a)			close(a)

	// Windows Socket macros

#define	WSAEWOULDBLOCK		EWOULDBLOCK			// NOTE:: fill in with error code for EWOULDBLOCK

//----------------------------------------
//				Data Types
//----------------------------------------

typedef	unsigned long		BOOL;
typedef	unsigned long		DWORD;
typedef	unsigned short		WORD;
typedef	unsigned char		BYTE;
typedef	unsigned char		byte;
typedef	long				LONG;
typedef	unsigned long		UINT;
typedef unsigned long		ULONG;
typedef	unsigned short		USHORT;

typedef	void				VOID;
typedef void *				PVOID;
typedef void *				LPVOID;

typedef struct _RECT
{ 
	LONG left; 
	LONG top; 
	LONG right; 
	LONG bottom; 
} RECT;

typedef struct tagRGBQUAD
{ 
	BYTE rgbBlue;
	BYTE rgbGreen;
	BYTE rgbRed;
	BYTE rgbReserved;
} RGBQUAD;

typedef struct tagBITMAPINFOHEADER
{ 
	DWORD biSize; 
	LONG biWidth; 
	LONG biHeight; 
	WORD biPlanes; 
	WORD biBitCount;
	DWORD biCompression; 
	DWORD biSizeImage; 
	LONG biXPelsPerMeter; 
	LONG biYPelsPerMeter; 
	DWORD biClrUsed; 
	DWORD biClrImportant; 
} BITMAPINFOHEADER; 

typedef struct tagBITMAPINFO
{ 
	BITMAPINFOHEADER bmiHeader; 
	RGBQUAD          bmiColors[1]; 
} BITMAPINFO, *PBITMAPINFO; 

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				Function Prototypes
//----------------------------------------

