/*---------------------------------------------------------------------------

	RDM_BranchManager.cpp

	Copyright (c) 2003, Raritan Computer, Inc.

	Raritan Device Manager Protocol service handler class (CRDM_BranchManager)

---------------------------------------------------------------------------*/

#include	<stdio.h>
#include	<pp/syms.h>
#include	<pp/RDM_BranchManager.h>
#include	<pp/RDM_Database.h>
#include	<pp/Hash32.h>

//----------------------------------------
//				Equates
//----------------------------------------

//----------------------------------------
//				Data Types
//----------------------------------------

//----------------------------------------
//				Function Prototypes
//----------------------------------------

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				Code
//----------------------------------------

//---------------------------------------------------------------------------
//							CRDM_BranchManager
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//
	CRDM_BranchManager::CRDM_BranchManager
	(
		CRDM		  * pNewRDM,		// Ptr to the new RDM object
		CRDM_Database * pDBService		// Ptr to the database serivce
							// or NULL = no add to DB service
	)
//
//	Initialize data items
//
//---------------------------------------------------------------------------
{
	// this is just demonstration code, name should be acquired properly
	pName		= "TestBM";
	hashCode	= Hash32(0,pName);
	pRDM		= pNewRDM;

	if (pDBService != NULL)
		pDBService->AddBranchManager( this );

	//printf("BRANCHMANAGER: Adding %s %08X\n",pName, this );
}

//---------------------------------------------------------------------------
//
	CRDM_BranchManager::~CRDM_BranchManager
	(
	)
//
//	Cleanup
//
//---------------------------------------------------------------------------
{
}

//---------------------------------------------------------------------------
//
	int						// 0 or Error code
	CRDM_BranchManager::Append
	(
		CSession	* NOTUSED(pUserSession),// User session or NULL for super user
		CSXDB_Node	* NOTUSED(pNode),	// The Node to be appended too
		CSXDB_Node	* NOTUSED(pData)	// Ptr to data to append
	)
//
//	Virtual function implemented in the branch manager derived class.
//	This function processes append requests from a client
//
//---------------------------------------------------------------------------
{
	return -1;
}

//---------------------------------------------------------------------------
//
	int						// 0 or Error code
	CRDM_BranchManager::Update
	(
		CSession	* NOTUSED(pUserSession),// User session or NULL for super user
		CSXDB_Node	* NOTUSED(pNode),	// The Node to be appended too
		CSXDB_Node	* NOTUSED(pData)	// Ptr to data to append
	)
//
//	Virtual function implemented in the branch manager derived class.
//	This function processes update requests from a client
//
//---------------------------------------------------------------------------
{
	return -1;
}

//---------------------------------------------------------------------------
//
	int						// 0 or Error code
	CRDM_BranchManager::Delete
	(
		CSession	* NOTUSED(pUserSession),// User session or NULL for super user
		CSXDB_Node	* NOTUSED(pNode)	// The Node to be appended too
	)
//
//	Virtual function implemented in the branch manager derived class.
//	This function processes append requests from a client
//
//---------------------------------------------------------------------------
{
	return -1;
}

//---------------------------------------------------------------------------
//
	int						// 0 = Not processed, 1 = processed
	CRDM_BranchManager::PreProcessDelete
	(
		CSession	* NOTUSED(pUserSession),// User session or NULL for super user
		const char	* NOTUSED(pXPath),	// Ptr to the xpath
		CSIO		* NOTUSED(pResponse)	// SIO Response
	)
//
//	Gives a branch manager a change to process a delete request on it's own
//	before the normal CRDM_Database::Delete() method does it's normal processing.
//	If this function returns 0, normal Delete processing will continue.
//	If 1 is returned, normal delete processing will not continue 
//	If 1 is returned, then this function must put the response in pResponse
//
//---------------------------------------------------------------------------
{
	return 0;
}

//---------------------------------------------------------------------------
//
	int						// 0 or error code
	CRDM_BranchManager::AssociateOutlet
	(
		const char	* NOTUSED(port_id),	// The target that will be controlled
		const char	* NOTUSED(outlet_id)	// The outlet that controls it
	)
//
//	Virtual function implemented in the branch manager derived class.
//	This function associates an outlet to a port in paragon devices
//
//---------------------------------------------------------------------------
{
	return -1;
}

//---------------------------------------------------------------------------
//
	int						// 0 or error code
	CRDM_BranchManager::SetPowerState
	(
		const char	* NOTUSED(outlet_id),	// The outlet to set the power state for
		int		NOTUSED(state)		// 0 = cycle power, 1 = On, 2 = Off
	)
//
//	Virtual function implemented in the branch manager derived class.
//	This function sets the power state of an outlet
//
//---------------------------------------------------------------------------
{
	return -1;
}

//---------------------------------------------------------------------------
//
	char *						// Ptr to the allocated power status string
	CRDM_BranchManager::GetPowerStripStatus
	(
		const char	* NOTUSED(strip_id)	// The outlet strip to get the status for
	)
//
//	Virtual function implemented in the branch manager derived class.
//	This function returns the power strip status as an XML string.
//	This function allocates the space for the string. The user must
//	delete the string when done using it.
//
//---------------------------------------------------------------------------
{
	return NULL;
}

