/**	
 *	@file	RDM_DDA_Device.cpp
 *	@brief	Implementation of CDD_Device
 *
 *	Object that represents  .
 */

#include <assert.h>
#include <pp/syms.h>
#include <pp/RDM_DDA_Device.h>
#include <pp/RDM_DDA_Utility.h>
#include <pp/SXDB_Parse_Table.h>

/*----------------------------------------
 *	Equates
 *--------------------------------------*/

/*----------------------------------------
 *	Data Types
 *--------------------------------------*/

/*----------------------------------------
 *	Function Prototypes
 *--------------------------------------*/

/*----------------------------------------
 *	Static Data
 *--------------------------------------*/

//----------------------------------------
//			Device Parse Table
//----------------------------------------

typedef	struct
{
	const char	*pID;					// id of the device
	const char	*pType;					// type attribute
	const char	*pModel;				// Model attribute
	const char	*pBM;					// Branch Manager attribute
	const char	*pName;					// Name element
	int		baseDevice;				// !0 = base device
	int		calibrationSpeed;		// -1 = device does not support color calibration
} DEVICE_DATA;

#define	PT_STRUCT	DEVICE_DATA
PT_BEGIN	( "Device",		deviceTable,	PT_NO_UNKNOWN )
PT_ATT		( "id",			pID,		0,	PT_STRING_PTR )
PT_ATT		( "Type",		pType,		0,	PT_STRING_PTR )
PT_ATT		( "Model",		pModel,		0,	PT_STRING_PTR )
PT_ATT		( "BM",			pBM,		0,	PT_STRING_PTR )
PT_ATT		( "BaseDevice",	baseDevice,	0,	PT_INT | PT_CONDITION_1 )
PT_ATT		( "CalibrationSpeed", calibrationSpeed, -1, PT_INT )
PT_ELEM		( "Name",		pName,		0,	PT_STRING_PTR )
PT_END
#undef	PT_STRUCT

/*----------------------------------------
 *	Device Class
 *--------------------------------------*/


CDDA_Device::CDDA_Device(CRDM* pNewRDM) {
    pRDM = pNewRDM;
}

CDDA_Device::CDDA_Device(CRDM * pNewRDM, const char *pID, const char *pType, const char *pModel, const char *_pName, int baseDevice )
{
    pRDM = pNewRDM;
    initialize(pRDM, pID, pType, pModel, _pName, baseDevice);
}    

void
CDDA_Device::initialize(CRDM * NOTUSED(_pRDM), const char *pID, const char *pType, const char *pModel, const char *_pName, int baseDevice )
{
	// Init data

	sendChgEvent		= 0;
	sendStatusEvent		= 0;
	okToSendEvents		= 0;
	strncpy(id,pID,RDM_MAX_ID-1);

	// Add Device node

	BeginUpdate();

	DEVICE_DATA	dev;

	memset (&dev, 0, sizeof (dev));

	dev.pID			= id;
	dev.pType		= pType;
	dev.pModel		= pModel;
	dev.pBM			= pID;
	dev.pName		= _pName;
	dev.baseDevice	= baseDevice;
	dev.calibrationSpeed = 1;	///@todo what is the write value here ?

	//int result = SXDB_PT_Put(_pRDM->db, "/System", PT_CHILD_APPEND, deviceTable, &dev, baseDevice ? PT_CONDITION_1 : 0 );
	//assert(result >= 0);
	//(void)result;

	EndUpdate();
}

/*  --------------------------------------------------------------------*/
/** @see RDM_DDA_Device.h **/

CDDA_Device::~CDDA_Device( )
{
	// Delete our device node

	CSXDB_Node *p = pRDM->db->GetNodeFromID( id );
	if (p != NULL)
		delete p;
}


/*  --------------------------------------------------------------------*/
/** @see RDM_DDA_Device.h **/

void CDDA_Device::BeginUpdate()
{
	pRDM->db->BeginAccess(1);
}

/*  --------------------------------------------------------------------*/
/** @see RDM_DDA_Device.h **/

void CDDA_Device::EndUpdate()
{
	pRDM->db->EndAccess();

	if (sendChgEvent && okToSendEvents)
	{
	}

	if (sendStatusEvent && okToSendEvents)
	{
	}

	sendChgEvent = sendStatusEvent = 0;
}

/*  --------------------------------------------------------------------*/
/** @see RDM_DDA_Device.h **/

void CDDA_Device::SetName( const char *pNewName )
{
	char	name[RDM_MAX_NAME];
	strncpy(name,pNewName,RDM_MAX_NAME);
	name[RDM_MAX_NAME-1]=0;
	CSXDB_Node *p = pRDM->db->GetNodeFromID( id );
	if (p != NULL)
	{
		pRDM->db->PutData("","Name",SXDB_TYPE_ELEMENT,name,NULL,p);
	}

	sendChgEvent = 1;
}

/*  --------------------------------------------------------------------*/
/** @see RDM_DDA_Device.h **/

const char * CDDA_Device::GetID( )
{
	return id;
}

/*  --------------------------------------------------------------------*/
/** @see RDM_DDA_Device.h **/
int  CDDA_Device::WriteData( const char * NOTUSED(pID), const char * NOTUSED(pKey), const char * NOTUSED(pData) )
{
	return -1;
}

/*  --------------------------------------------------------------------*/
/** @see RDM_DDA_Device.h **/
void CDDA_Device::CommitData()
{
}

/*  --------------------------------------------------------------------*/
/** @see RDM_BranchManager.h **/
int CDDA_Device::Update( CSession * NOTUSED(pUserSession), CSXDB_Node * NOTUSED(pNode), CSXDB_Node * NOTUSED(pData)  )
{
	return -1;
}


