/*-------------------------------------------------------------------------------

	RDM_Subscription.cpp

	Copyright (c) 2003, Raritan Computer, Inc.

	Raritan Device Manager Protocol Notification Subscription class (CRDM_Subscription)

--------------------------------------------------------------------------------*/

#include	<stdio.h>
#include	<string.h>
#include	<pp/syms.h>
#include	<pp/CmdLineParse.h>
#include	<pp/Hash32.h>
#include	<pp/RDM_Subscription.h>
#include	<pp/RDM_Notify.h>

//----------------------------------------
//				Equates
//----------------------------------------

//----------------------------------------
//				Data Types
//----------------------------------------

//----------------------------------------
//				Function Prototypes
//----------------------------------------

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				Code
//----------------------------------------

//--------------------------------------------------------------------------------
//									CRDM_Subscription
//--------------------------------------------------------------------------------

//--------------------------------------------------------------------------------
//
	CRDM_Subscription::CRDM_Subscription
	(
	)
//
//	Initialize data items
//
//------------------------------------------------------------------------------//
{
	pIDList			= NULL;
	idCount			= 0;
	idAllocated		= 0;
	subscriptionID	= 0;
	pNext			= NULL;
	pNotifyObject	= NULL;

	this->ClearEvents();
}

//--------------------------------------------------------------------------------
//
	CRDM_Subscription::~CRDM_Subscription
	(
	)
//
//	Cleanup
//
//------------------------------------------------------------------------------//
{
	RDM_HASHED_ID	* temp;

	// Remove Subscription from list

	if (pNotifyObject != NULL)
		pNotifyObject->RemoveSubscription( this );

	// Free the previous list, if allocated

	temp = pIDList;
	pIDList = NULL;

	if (temp != NULL)
		delete [] temp;

}

//--------------------------------------------------------------------------------
//
	int									// 0 = success
	CRDM_Subscription::SetSubscription
	(
		const char	*	_pIDList,			// Space or Comma separated ID list
		const char	*	pEventList			// Space or Comma separated event list
	)
//
//	Sets the ID and event codes for the subscription.
//
//------------------------------------------------------------------------------//
{
	int		result;
	int		count;
	int		_idCount = 0;
	int		eventCount = 0;
	int		x;
	char	token[RDM_MAX_ID];
	const char	*p;

	// HACK - Need to check security !!! HACK HACK

	// Allocate space for the IDs

	count = CountTokens( _pIDList, " ," );

	result = Allocate( count );

	if (result != 0)
		return result;

	// Set the ID

	p = _pIDList;

	for (x=0; x<count; x++ )
	{
		p = GetNextToken( p, token, RDM_MAX_ID, 0, " ," );

		if (token[0] == 0)
			break;

		// HACK - Check security here !

		SetID( x, token );
		_idCount++;
	}

	// Set the events

	eventCount = this->AddEvents( pEventList );

	return (eventCount > 0 && _idCount > 0) ? 1 : 0;
}

//--------------------------------------------------------------------------------
//
	int									// 0 = success
	CRDM_Subscription::Allocate
	(
		int		count					// # of ID spaces to create
	)
//
//	Allocates space for <count> unique IDs.
//
//	There are two ways to set the ID(s) of a subscription.
//		1) Call Allocate(x) to reserve space for many IDs and then
//		   call SetID( x,ID ) for each ID. Also Call 
//		   AddEvents( event ) (inheiretted from CRDM_EventCodeSet)
//		2) Simply call SetSubscription( ID, event )
//
//------------------------------------------------------------------------------//
{
	RDM_HASHED_ID	* temp;

	// Free the previous list, if allocated

	temp = pIDList;
	pIDList = NULL;

	if (temp != NULL)
		delete temp;

	// Allocate new list

	idAllocated = count;
	idCount = 0;

	temp = new RDM_HASHED_ID[count];

	if (temp == NULL)
	{
		idAllocated = 0;
		return -1;
	}

	memset( temp, 0, sizeof(RDM_HASHED_ID) * count);

	pIDList = temp;

	return 0;
}

//--------------------------------------------------------------------------------
//
	int									// 0 = success
	CRDM_Subscription::SetID
	(
		int		index,					// Which ID to set
		const char	*pID					// The ID String
	)
//
//	Sets a specific ID in the ID list
//
//------------------------------------------------------------------------------//
{
	if (index > idAllocated)
		return -1;

	if (pID != NULL)
	{
		strncpy( pIDList[index].ID, pID, RDM_MAX_ID-1 );
		pIDList[index].ID[RDM_MAX_ID-1] = 0;
	}
	else
		pIDList[index].ID[0] = 0;
	pIDList[index].hash = Hash32( 0, pID );

	if (idCount <= index)
		idCount = index+1;

	return 0;
}

//--------------------------------------------------------------------------------
//
	int									// !0 = notification match
	CRDM_Subscription::Test
	(
		const char	*	pID,				// Ptr to the ID string
		int			hash,				// Hash code of string
		int			eventID				// Numeric event ID
	)
//
//	Returns true if the event & ID pair matches the subscription
//
//------------------------------------------------------------------------------//
{
	int	x;

	for (x=0;x<idCount;x++)
	{
		if (pIDList[x].ID[0] == '*')
		{
			if (this->IsEvent( eventID ))
				return 1;
			break;
		}

		if (hash == pIDList[x].hash)
		{
			if (strcmp(pID,pIDList[x].ID) == 0)
			{
				if (this->IsEvent( eventID ))
					return 1;
			}

			break;
		}
	}

	return 0;
}

//--------------------------------------------------------------------------------
//
	void
	CRDM_Subscription::Notify
	(
		RDM_EVENT	* NOTUSED(pEvent)			// The event
	)
//
//	Sends a notification to this subscription
//
//------------------------------------------------------------------------------//
{
}




