/*--------------------------------------------------------------------------------

	RDMP.h

	Copyright (c) 2003, Raritan Computer, Inc.

	Header file for RDMP.cpp and the CRDMP class

--------------------------------------------------------------------------------*/

#ifndef _RDMP_H_
#define	_RDMP_H_

#include "pp/SXML_Errors.h"
#include "pp/SXDB.h"
#include "pp/SXML.h"
#include "pp/Session.h"
#include "pp/SIO.h"
#include "pp/RDM_Service.h"
#include "pp/OS_Port.h"

//----------------------------------------
//				Equates
//----------------------------------------

//----------------------------------------
//				Data Types
//----------------------------------------

//----------------------------------------
//				Function Prototypes
//----------------------------------------

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				Class
//----------------------------------------

class	CRDMP
{
public:
	CRDMP();
	~CRDMP();

	int									// 0 or error code if request failed
	Command
	(
		CSession *	pUserSession,		// The user session or NULL for super user
		CSIO	*	pRequest,			// The request
		CSIO	*	pResponse			// The response -
										// Contains the return value on exit
	);

	void
	AddService
	(
		CRDM_Service *pService			// The service to add
	);

	void
	RemoveService
	(
		CRDM_Service *pService			// The service to remove
	);

	CRDM_Service *						// NULL or ptr to the service object
	FindService
	(
		const char *	pServiceName			// Name of the service
	);

	// --------------------------------
	// Data
	// --------------------------------

private:

	CRDM_Service *	pServiceList;		// Ptr to the first CRDM_Service in the linked list
	OS_CRITICAL_SECTION		cs;			// Critical section object used to control access to RDM

};

#endif // _RDMP_H_

