/*--------------------------------------------------------------------------------

	RDM_EventRecord.h

	Copyright (c) 2004, Raritan Computer, Inc.

	Definition of the RDM_EventRecord format
	This was put in it's own file to avoid circular includes

--------------------------------------------------------------------------------*/

#ifndef _RDM_EventRecord_H_
#define	_RDM_EventRecord_H_

#include "pp/RDM_OS_Dependent.h"
#include "pp/RDM_Definitions.h"

//----------------------------------------
//				Equates
//----------------------------------------


//----------------------------------------
//				Data Types
//----------------------------------------

	// Internal Binary format of an event

#pragma pack(1)
typedef struct
{
	int			serialNo;				// Event Serial Number
	char		id[RDM_MAX_ID];			// The ID the event is associated with
	RDM_TIME	time;					// Time & Date
	BYTE		event;					// event code (Byte value to save space, expand when needed)
	char		data[RDM_MAX_NOTIFICATION_DATA]; // <Data> section (Must be last field)
} RDM_EVENT;
#pragma pack()

//----------------------------------------
//				Function Prototypes
//----------------------------------------

//----------------------------------------
//				Static Data
//----------------------------------------

#endif // _RDM_EventRecord_H_


