/*--------------------------------------------------------------------------------

	RDM_Local_Notify.h

	Copyright (c) 2003, Raritan Computer, Inc.

	Header file for RDM_Local_Notify.cpp and the CRDM_Local_Notify class

--------------------------------------------------------------------------------*/

#ifndef _RDM_Local_Notify_H_
#define	_RDM_Local_Notify_H_

#include "pp/RDM_Subscription.h"

//----------------------------------------
//				Equates
//----------------------------------------

//----------------------------------------
//				Data Types
//----------------------------------------

	// Definition of call back function

typedef int (CRDM_Local_CallBack)
			(
				void	  *	pUserData,
				RDM_EVENT *	pEvent				// The event
			);

//----------------------------------------
//				Function Prototypes
//----------------------------------------

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				Class
//----------------------------------------

class	CRDM_Local_Notify : public CRDM_Subscription
{
public:

	CRDM_Local_Notify();

	~CRDM_Local_Notify();

	void
	SetCallBack
	(
		CRDM_Local_CallBack	*pFunc,		// Ptr to the function
		void *				pUserData	// Ptr to user data passed back to callback func
	);

	virtual
	void
	Notify
	(
		RDM_EVENT	*pEvent				// The event
	);

	// --------------------------------
	// Data
	// --------------------------------

private:

	CRDM_Local_CallBack	*pCallBack;		// Ptr to the user's call back
	void			*	pUserData;		// Data passed back to the call back function

};

#endif // _RDM_Local_Notify_H_


