/*--------------------------------------------------------------------------------

	RDM_Notify.h

	Copyright (c) 2003, Raritan Computer, Inc.

	Header file for RDM_Service.cpp and the CRDM_Notify class

--------------------------------------------------------------------------------*/

#ifndef _RDM_Notify_H_
#define	_RDM_Notify_H_

#include "pp/Session.h"
#include "pp/RDM_Service.h"
#include "pp/RDM_Subscription.h"
#include "pp/OS_Port.h"
#include "pp/RDM_EventRecord.h"
#include "pp/CircularFile.h"

//----------------------------------------
//				Equates
//----------------------------------------

#define	LOG_FILE_SIGNATURE	0x02EFF560	// Signature for the log file header

#define	RDM_NOTIFY_NEWEST	0x7FFFFFFF
#define	RDM_NOTIFY_OLDEST	0x80000000

//----------------------------------------
//				Data Types
//----------------------------------------

//----------------------------------------
//				Function Prototypes
//----------------------------------------

	void
	RDM_ConvertEventToXML
	(
		RDM_EVENT *	pEvent,				// Where to put the event data
		char	  * pString,			// Where to put the text
										// Must be <RDM_MAX_NOTIFICATION> bytes long
		int			useTime = 1,		// !0 = include time
		int			useID = 1,			// !0 = include Node ID
		int			useSerialNo = 1,	// !0 = include serial number
		int			useData = 1,		// !0 = include data
		int			subID = -1,			// >=0 = include this subscription ID
		int			useDeviceID = 1		// !0 = include deviceID data
	);

	void
	RDM_ConvertEventToText
	(
		RDM_EVENT *	pEvent,				// Where to put the event data
		char	  * pString,			// Where to put the text
										// Must be <RDM_MAX_TEXT_EVENT> bytes long
		BOOL		bUTCFormat = TRUE
	);

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				Class
//----------------------------------------

class	CRDM_Notify : public CRDM_Service
{
public:

	CRDM_Notify
	(
	);

	~CRDM_Notify();

	void
	LogToFile
	(
		CCircularFile *pLogFile		// The log file
	);

	virtual
	int									// 0 or error code if request failed
	Command
	(
		CSession	*	pUserSession,	// The user session or NULL for super user
		CSXDB_Node	*	pRootNode,		// Ptr to the root node of our functions
		CSIO		*	pResponse		// The response -
										// Contains the return value on exit
	);

	int								// I/O error on output
	Subscribe
	(
		CSession	*pUserSession,	// User session
		CSXDB_Node	*pNode,			// The node of the function
		CSIO		*pResponse		// SIO Response
	);

	int								// I/O error on output
	Unsubscribe
	(
		CSession	*pUserSession,	// User session
		CSXDB_Node	*pNode,			// The node of the function
		CSIO		*pResponse		// SIO Response
	);

	int								// I/O error on output
	NotifyFunction
	(
		CSession	*pUserSession,	// User session
		CSXDB_Node	*pNode,			// The node of the function
		CSIO		*pResponse		// SIO Response
	);

	int								// I/O error on output
	GetEventsFunction
	(
		CSession	*pUserSession,	// User session
		CSXDB_Node	*pNode,			// The node of the function
		CSIO		*pResponse		// SIO Response
	);

	void
	Notify
	(
		const char	*	pID,				// Ptr to the Unique ID
		int			event,				// The event code
		const char	*	pData				// Ptr to the data 
	);

	void
	AddSubscription
	(
		CRDM_Subscription	*pSub		// Ptr to the subscription to add
	);

	void
	RemoveSubscription
	(
		CRDM_Subscription	*pSub		// Ptr to the subscription to remove
	);

	inline
	void
	SetRDM
	(
		class CRDM	*	_pRDM			// Ptr to the RDM object
	)
	{
		this->pRDM = _pRDM;
	};

	int									// # of events returned
	GetEvents
	(
		RDM_EVENT *	pEvent,				// Where to put the event data
		int			serialNo,			// The starting serialNo
		int			count				// # of events to get 
										// (+ = get newer events, - = get older events)
	);

	int								// 0 or error code
	Sync
	(
		CSIO	*pDestFile			// File to write to
	);

	int
	GetLastSerialNo
	(
	);

protected:

	int									// The serialNo of the found event
										// <0 = no events in file
	FindEvent
	(
		int			serialNo			// The event serial number
	);

	// --------------------------------
	// Data
	// --------------------------------

private:

	OS_CRITICAL_SECTION	cs;				// cs to access notification data
	CRDM_Subscription	*pSubscriptionList;	// Listed list of subscriptions

	class CRDM	*	pRDM;				// Ptr to the RDM object

	int				serialNo;			// Next event serial number

	// Event Log File Data

	CCircularFile *	pLogFile;			// The log file

};

#endif // _RDM_Notify_H_

