/*---------------------------------------------------------------------------

	RDM_Session.h

	Copyright (c) 2003, Raritan Computer, Inc.

	Header file for RDM_Service.cpp and the CRDM_Session class

---------------------------------------------------------------------------*/

#ifndef _RDM_Session_H_
#define	_RDM_Session_H_

#include "pp/Session.h"
#include "pp/RDM_Service.h"
#include "pp/RDM_Subscription.h"
#include "pp/RDM.h"

//----------------------------------------
//				Equates
//----------------------------------------

//----------------------------------------
//				Data Types
//----------------------------------------

//----------------------------------------
//				Function Prototypes
//----------------------------------------

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				Class
//----------------------------------------

class	CRDM_Session : public CRDM_Service
{
public:

	CRDM_Session
	(
		class CRDM	*	pRDM			// Ptr to the RDM object
	);

	virtual ~CRDM_Session();

	virtual
	int									// 0 or error code if request failed
	Command
	(
		CSession	*	pUserSession,	// User session
		CSXDB_Node	*	pRootNode,		// Ptr to root node of our functions
		CSIO		*	pResponse		// The response -
										// Contains the return value on exit
	);

	int								// I/O error on output
	GetSessionID
	(
		CSession	*pUserSession,	// User session
		CSXDB_Node	*pNode,			// The node of the function
		CSIO		*pResponse		// SIO Response
	);

    virtual
	int								// I/O error on output
	Open
	(
		CSession	*pUserSession,	// User session
		CSXDB_Node	*pNode,			// The node of the function
		CSIO		*pResponse		// SIO Response
	);

    virtual
	int								// I/O error on output
	Close
	(
		CSession	*pUserSession,	// User session
		CSXDB_Node	*pNode,			// The node of the function
		CSIO		*pResponse		// SIO Response
	);

	int								// I/O error on output
	QueryPermission
	(
		CSession	*pUserSession,	// User session
		CSXDB_Node	*pNode,			// The node of the function
		CSIO		*pResponse		// SIO Response
	);

	// --------------------------------
	// Platform dependent methods
	// --------------------------------

	virtual
	CSessionManager *					// Ptr to the CSessionManager object
	DEP_GetSessionManager
	(
	);

    virtual
    void
    DEP_SetReferralUserObject
    (
        CSession * pSession
    );

	// --------------------------------
	// Data
	// --------------------------------

protected:

	class CRDM	*	pRDM;				// Ptr to the RDM object
};

#endif // _RDM_Session_H_

