/*---------------------------------------------------------------------------

	SessionReferralObject.cpp

	Copyright (c) 2004, Raritan Computer, Inc.

	Header file for SessionReferralObject.cpp and the CSessionReferralObject class

---------------------------------------------------------------------------*/

#ifndef _SessionReferralObject_H_
#define	_SessionReferralObject_H_

#include "pp/Session.h"
#include "pp/timer.h"

//----------------------------------------
//				Equates
//----------------------------------------

#define	SESSION_REFERRAL_CLASS	0xF5a10002

//----------------------------------------
//				Data Types
//----------------------------------------

class CSessionReferralObject;

//----------------------------------------
//				Function Prototypes
//----------------------------------------

	CSessionReferralObject *			// Object Ptr or NULL
	AttatchSessionReferralObject
	(
		CSession *	pSession,			// The session to attach to
		int			timeout				// The timeout period in ms, 0 = NO timeout
	);

	void
	RemoveSessionReferralObject
	(
		CSession *	pSession			// The session to attach to
	);

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				Class
//----------------------------------------

class	CSessionReferralObject : public CSessionObject, public CTimer
{
public:

	CSessionReferralObject
	(
		CSession *	pSession,			// The session to attach to
		int			timeout				// The timeout period in ms, 0 = NO timeout
	);

	virtual
	~CSessionReferralObject();

	void
	Event
	(
		CSession	* pUserSession,		// The session in question...
		int			event,				// Which SESSION_EVENT_ code
		const void		*pData				// Data associated with the event
	);

	virtual void TimerProc();

	void
	Release
	(
	);

private:
	CSession *	pSession;				// Ptr to the session we are attached to
	int			aquired;				// !0 when we have aquired the session
};

#endif // _SessionReferralObject_H_

