/**	
 *  @file	ppRFPUnpack.h
 * 
 *  @brief	ppRFPUnpack definition
 * 
 *  eirc firmware specific version of RFPUnpack
 *	
 */

#ifndef _ppRFPUnpack_h_
#define _ppRFPUnpack_h_
#include "pp/RFPUnpack.h"

namespace pp
{

/*----------------------------------------
 *	Equates
 *--------------------------------------*/

/*----------------------------------------
 *	Data Types
 *--------------------------------------*/

/*----------------------------------------
 *	Function Prototypes
 *--------------------------------------*/

/*----------------------------------------
 *	Forward References
 *--------------------------------------*/

/*----------------------------------------
 *	Class
 *--------------------------------------*/

class ppRFPUnpack : public CRFPUnpack
{
public:

	/*  --------------------------------------------------------------------*/
	/** 
     *  @brief	Constructor for a ppRFPUnpack object
	 *
	 */

	ppRFPUnpack( );
	virtual ~ppRFPUnpack();

	/*  --------------------------------------------------------------------*/
	/** 
     *  @brief	Resolves A metafile into a realfile name
     * 
     *  This function can be overridden to resolve metafiles.
     *  Te default implmentation returns an error.
     * 
     *  @param  pMetaFileName   Ptr to the Metafile to resolve
     *  @param  pOutRealFileName Buffer to return the real file name
     *  @return				Returns RFP_OK or RFP_ERROR_ if file
     *                      cannot be resolved
	 *
	 */

	virtual int ResolveMetaFile( char *pMetaFileName, char *pOutRealFileName );

	/*  --------------------------------------------------------------------*/
	/** 
     *  @brief  Cleans up after a Metafile.
     * 
     *  This function can be overridden to do any needed cleanup of
     *  resolved metafiles._ppRFPUnpack_h_
     *  The default implementation does nothing.
     * 
     *  @param  pMetaFileName   Ptr to the Metafile to resolve
     *  @param  pResolvedFileName Buffer containing the real file
     *                            name
     *  @return				Returns RFP_OK or RFP_ERROR_ if file
     *                      cannot be resolved
	 *
	 */

	virtual int ReleaseMetaFile( char *pMetaFileName, char *pResolvedFileName );

	/*  --------------------------------------------------------------------*/
	/** 
     *  @brief	Called to Validate the header-version, model & etc.
     * 
     *  The default behavior is to return RFP_OK for all headers.
     * 
     *  @param  pRFP        Ptr to the RFP header structure
     *  @return             RFP_OK, RFP_SKIP_FILE or RFP_ERROR_
	 *
	 */

	virtual int ValidateHeader( RFP * pRFP );

	/*  --------------------------------------------------------------------*/
	/** 
     *  @brief	Called to Validate a file-version, model & etc.
     * 
     *  The default behavior is to return RFP_OK for all files.
     * 
     *  @param  pRFP_File   Ptr to the RFP file structure
     *  @return             RFP_OK, RFP_SKIP_FILE or RFP_ERROR_
	 *
	 */

	virtual int ValidateFile( RFP_FILE * pRFP_File );

	/*  --------------------------------------------------------------------*/
	/** 
     *  @brief  Called to run a script file
     * 
     *  After a script file has been downloaded, this method is
     *  called to exeute the script. This function should be
     *  overriden.
     * 
     *  @param  pFileName   Ptr to the script file name
     *  @param  pScriptType Ptr to the script type (i.e. "BASH")
     *  @return				Returns RFP_OK or RFP_ERROR_ if file
     *                      cannot be executed
	 *
	 */

	virtual int RunScript( char *pFileName, char * pScriptType );
};

} // namespace

#endif	// _ppRFPUnpack_h_


