/**	
 *  @file	ppRFPUnpack.cpp
 * 
 *  @brief  Class derived from CRFPUnpack
 *          Implements eric firmware specific RFP features
 *
 *	
 */

#include	<stdio.h>
#include	<string.h>
#include	<assert.h>
#include	<pp/syms.h>
#include	<pp/ppRFPUnpack.h>

namespace pp
{

/*----------------------------------------
 *	Equates
 *--------------------------------------*/

/*----------------------------------------
 *	Data Types
 *--------------------------------------*/

/*----------------------------------------
 *	Function Prototypes
 *--------------------------------------*/

/*----------------------------------------
 *	Forward References
 *--------------------------------------*/

/*----------------------------------------
 *	Code
 *--------------------------------------*/

/*  --------------------------------------------------------------------*/
ppRFPUnpack::ppRFPUnpack(  )
{
}

/*  --------------------------------------------------------------------*/
ppRFPUnpack::~ppRFPUnpack()
{
}

/*  --------------------------------------------------------------------*/
int ppRFPUnpack::ResolveMetaFile( char * pMetaFileName, char * pOutRealFileName )
{
	// @todo Make Metafile Conversions.
	// Here we need to convert Metafile name (virtual file names)
	// Into real file names.
	// Example: "CONFIG" maybe converted to "/usr/!config"
	
	if (strcmp(pMetaFileName,"CONFIG") == 0)
	{
		strcpy(pOutRealFileName, "/usr/!config");
		return RFP_OK;
	}
		
	return RFP_ERROR_BAD_METAFILE;
}

/*  --------------------------------------------------------------------*/
int ppRFPUnpack::ReleaseMetaFile( char * NOTUSED(pMetaFileName), char * NOTUSED(pResolvedFileName) )
{
	// @todo Clean up after any metafile that was created
	// ResolveMetaFile() may actually create a file in response to a metafile
	// this function is called after the metafile is no longer needed
	// and we can delete it.
	
	return RFP_OK;
}

/*  --------------------------------------------------------------------*/
int ppRFPUnpack::ValidateHeader( RFP * NOTUSED(pRFP) )
{
	// @todo Implement header validateion
	// This function needs to make sure the RFP is valide for this machine
	// This function can check the pRFP->model, ->version,->versionMin,
	// ->versionMax and etc. to make sure the RFP is good
	
	return RFP_OK;
}

/*  --------------------------------------------------------------------*/
int ppRFPUnpack::ValidateFile( RFP_FILE * NOTUSED(pRFP_File) )
{
	// @todo Implement file validateion
	// This function needs to make sure that each file is valide for this machine
	// This function can check the pRFP_File->model, ->version,->versionMin,
	// ->versionMax, ->component and etc. to make sure the RFP_File is good
	// This function can return RFP_OK, or RFP_ERROR_ to terminate processing
	// this RFP, or RFP_SKIP_FILE to ignire this one file and continue with the
	// next file.
	
	return RFP_OK;
}

/*  --------------------------------------------------------------------*/
int ppRFPUnpack::RunScript( char * pFileName, char * pScriptType )
{
	char string[255];
	int  result;
	
	// Check the script type
	if (strcmp(pScriptType, "Bash") != 0)
		return RFP_ERROR_BAD_SCRIPT;
	
	sprintf(string, "source %s", pFileName );
	result = system(string);
	result = WEXITSTATUS(result) & 0xFF;

	// Script MUST return 0 for success
	// Anything else is treated as an RFP_ERROR_ code

	return result;
}

} // namespace


