/*--------------------------------------------------------------------------------

	rfp_test.cpp


	Test program for RFPParse. Also validates rfp files

--------------------------------------------------------------------------------*/

#include	<stdio.h>
#include	<string.h>
#include	<pp/syms.h>
#include	<pp/RFPUnpack.h>

using namespace pp;

//----------------------------------------
//				Equates
//----------------------------------------

//----------------------------------------
//				Data Types
//----------------------------------------

class MyCRFPUnpack : public CRFPUnpack
{
	virtual int RunScript( char * NOTUSED(pFileName), char * NOTUSED(pScriptType) ) {return RFP_OK;}
	virtual int AllocateSIO( RFP_FILE * NOTUSED(pRFP_File), CSIO **ppSIO ) {*ppSIO = new CSIO_DMEM(); return RFP_OK;}
	virtual void FreeSIO( RFP_FILE * NOTUSED(pRFP_File), CSIO *pSIO ) {delete pSIO; }
	virtual int PostProcessFile( RFP_FILE * NOTUSED(pRFP_File), CSIO * NOTUSED(pSIO) ) {return RFP_OK;}
	virtual int ResolveMetaFile( char *pMetaFileName, char *pOutRealFileName ) {strcpy(pOutRealFileName,pMetaFileName); return RFP_OK;}
	virtual int ValidateHeader( RFP * pRFP )
	{
		printf("---[ RFP ]-----------------------------\n");

		printf("Title:       %s\n",pRFP->title);
		printf("Description: %s\n",pRFP->description);
		printf("Copyright:   %s\n",pRFP->copyRight);
		printf("Publisher:   %s\n",pRFP->publisher);
		printf("Model:       %s\n",pRFP->model);
		printf("Version:     %s\n",pRFP->version);
		printf("VersionMin:  %s\n",pRFP->versionMin);
		printf("VersionMax:  %s\n",pRFP->versionMax);
		printf("isSigned:    %s\n",pRFP->isSigned ? "Yes" : "No");
		printf("autoRestart: %s\n",pRFP->autoRestart ? "Yes" : "No");
		printf("disableOtherSessions: %s\n",pRFP->disableOtherSessions ? "Yes" : "No");
		printf("supportedDensity:     %s\n",pRFP->supportedDensity);
		printf("supportedHardware:    %s\n",pRFP->supportedHardware);
		printf("Files:       %d\n",GetFileCount());
		if (pRFP->tags)
			printf("Addition tags:\n%s\n",pRFP->tags);
		return RFP_OK;
	}
	virtual int ValidateFile( RFP_FILE * pRFP_File )
	{
		printf("---[ File ]----------------------------\n");

		printf(" File Name:     %s\n",pRFP_File->fileName);
		if (pRFP_File->metaFileName)
			printf(" Meta File:     %s\n",pRFP_File->metaFileName);
		printf(" Resolved Name: %s\n",pRFP_File->fileName);
		printf(" Length:        %d\n",pRFP_File->length);
		printf(" MaxLength:     %d\n",pRFP_File->maxLength);
		printf(" Script:        %s\n",pRFP_File->isScript ? pRFP_File->script : "None");
		printf(" Signed:        %s\n",pRFP_File->isSigned ? "Yes" : "No");
		printf(" Encrypted:     %s\n",pRFP_File->isEncrypted ? "Yes" : "No");
		printf(" Component:     %s\n",pRFP_File->component);
		printf(" Model:         %s\n",pRFP_File->model);
		printf(" Version:       %s\n",pRFP_File->version);
		printf(" VersionMin:    %s\n",pRFP_File->versionMin);
		printf(" VersionMax:    %s\n",pRFP_File->versionMax);
		return RFP_OK;
	}
};

//----------------------------------------
//				Function Prototypes
//----------------------------------------

void PrintError(int result);

//----------------------------------------
//				Static Data
//----------------------------------------

//----------------------------------------
//				Code
//----------------------------------------

//--------------------------------------------------------------------------------
//
	int
	main
	(
		int		argc,
		char *	argv[]
	)
//
//	RFP Parser test program
//
//--------------------------------------------------------------------------------
{
	MyCRFPUnpack	rfpUnpack;
	CSIO_FP			sio;
	int				error;
	char		*	pFileName;

	if (argc > 1)
		pFileName = argv[1];
	else
		pFileName = "testrfp.rfp";
		
	sio.Open(pFileName,"rb");
	rfpUnpack.SetCopyUnknownTagsOption(1);
	error = rfpUnpack.UnpackRFP( &sio );
	if (error != RFP_OK)
	{
		PrintError( error );
		return -1;
	}

	return error;
}


void PrintError(int result)
{
		switch (result)
		{
		case RFP_ERROR_CHECKSUM:				printf("RFP_ERROR_CHECKSUM\n");	break;
		case RFP_ERROR_FILE_FORMAT:				printf("RFP_ERROR_FILE_FORMAT\n");	break;
		case RFP_ERROR_DISK_MOUNT:				printf("RFP_ERROR_DISK_MOUNT\n");	break;
		case RFP_ERROR_DISK_UNMOUNT:			printf("RFP_ERROR_DISK_UNMOUNT\n");	break;
		case RFP_ERROR_FILE_WRITE:				printf("RFP_ERROR_FILE_WRITE\n");	break;
		case RFP_ERROR_PARTIAL_WRITE:			printf("RFP_ERROR_PARTIAL_WRITE\n");	break;
		case RFP_ERROR_MODEL_MISMATCH:			printf("RFP_ERROR_MODEL_MISMATCH\n");	break;
		case RFP_ERROR_VERSION_MISMATCH:		printf("RFP_ERROR_VERSION_MISMATCH\n");	break;
		case RFP_ERROR_TIMEOUT:					printf("RFP_ERROR_TIMEOUT\n");	break;
		case RFP_ERROR_CANCEL:					printf("RFP_ERROR_CANCEL\n");	break;
		case RFP_ERROR_REQUEST_FORMAT:			printf("RFP_ERROR_REQUEST_FORMAT\n");	break;
		case RFP_ERROR_FILE_NOT_FOUND:			printf("RFP_ERROR_FILE_NOT_FOUND\n");	break;
		case RFP_ERROR_INTERNAL:				printf("RFP_ERROR_INTERNAL\n");	break;
		case RFP_ERROR_XML_PARSE:				printf("RFP_ERROR_XML_PARSE\n");	break;
		case RFP_ERROR_PMCORE_STARTSERIAL:		printf("RFP_ERROR_PMCORE_STARTSERIAL\n");	break;
		case RFP_ERROR_LOCAL_RDM_SYNTAX:		printf("RFP_ERROR_LOCAL_RDM_SYNTAX\n");	break;
		case RFP_ERROR_LOCAL_FILE_OPEN:			printf("RFP_ERROR_LOCAL_FILE_OPEN\n");	break;
		case RFP_ERROR_LOCAL_FILE_ACCESS:		printf("RFP_ERROR_LOCAL_FILE_ACCESS\n");	break;
		case RFP_ERROR_LOCAL_SOCKET_OPEN:		printf("RFP_ERROR_LOCAL_SOCKET_OPEN\n");	break;
		case RFP_ERROR_LOCAL_SOCKET_CONNECT:	printf("RFP_ERROR_LOCAL_SOCKET_CONNECT\n");	break;
		case RFP_ERROR_LOCAL_SOCKET_WRITE:		printf("RFP_ERROR_LOCAL_SOCKET_WRITE\n");	break;
		case RFP_ERROR_LOCAL_SOCKET_READ:		printf("RFP_ERROR_LOCAL_SOCKET_READ\n");	break;
		case RFP_ERROR_STOP_SERVER:				printf("RFP_ERROR_STOP_SERVER\n");	break;
		case RFP_PACKET_ACK:					printf("RFP_PACKET_ACK\n");	break;
		case RFP_AUTO_REBOOT:					printf("RFP_AUTO_REBOOT\n");	break;
		case RFP_ERROR_NOT_COMPATIBLE_DENSITY:	printf("RFP_ERROR_NOT_COMPATIBLE_DENSITY\n");	break;
		case RFP_ERROR_NOT_COMPATIBLE_HARDWARE:	printf("RFP_ERROR_NOT_COMPATIBLE_HARDWARE\n");	break;
		case RFP_ERROR_MISSING_DENSITY_TAG:		printf("RFP_ERROR_MISSING_DENSITY_TAG\n");	break;
		case RFP_ERROR_MISSING_HARDWARE_TAG:	printf("RFP_ERROR_MISSING_HARDWARE_TAG\n");	break;
		case RFP_ERROR_NOT_COMPATIBLE:			printf("RFP_ERROR_NOT_COMPATIBLE\n");	break;
		case RFP_ERROR_BAD_SCRIPT:				printf("RFP_ERROR_BAD_SCRIPT\n");	break;
		case RFP_ERROR_FLASH_ERASE:				printf("RFP_ERROR_FLASH_ERASE\n");	break;
		case RFP_ERROR_FLASH_PROGRAM:			printf("RFP_ERROR_FLASH_PROGRAM\n");	break;
		case RFP_ERROR_FLASH_BLOCKCHECK:		printf("RFP_ERROR_FLASH_BLOCKCHECK\n");	break;
		case RFP_ERROR_FLASH_NORESPONSE:		printf("RFP_ERROR_FLASH_NORESPONSE\n");	break;
		case RFP_ERROR_MEMORY:					printf("RFP_ERROR_MEMORY\n");	break;
		case RFP_ERROR_TOO_MANY_FILES:			printf("RFP_ERROR_TOO_MANY_FILES\n");	break;
		case RFP_ERROR_NO_FILES:				printf("RFP_ERROR_NO_FILES\n");	break;
		case RFP_ERROR_RSA_KEY_BAD:				printf("RFP_ERROR_RSA_KEY_BAD\n");	break;
		case RFP_ERROR_BAD_SIGNATURE:			printf("RFP_ERROR_BAD_SIGNATURE\n");	break;
		case RFP_ERROR_CANNOT_READ_FILE:		printf("RFP_ERROR_CANNOT_READ_FILE\n");	break;
		case RFP_ERROR_CANNOT_WRITE_FILE:		printf("RFP_ERROR_CANNOT_WRITE_FILE\n");	break;
		case RFP_ERROR_MAXLENGTH_NOT_LAST:		printf("RFP_ERROR_MAXLENGTH_NOT_LAST\n");	break;
		case RFP_ERROR_MAXLENGTH_AND_LENGTH:	printf("RFP_ERROR_MAXLENGTH_AND_LENGTH\n");	break;
		case RFP_ERROR_PUBLIC_KEY_MISSING:		printf("RFP_ERROR_PUBLIC_KEY_MISSING\n");	break;
		case RFP_ERROR_RSA_KEY_MISSING:			printf("RFP_ERROR_RSA_KEY_MISSING\n");	break;
		case RFP_ERROR_RC4_KEY_MISSING:			printf("RFP_ERROR_RC4_KEY_MISSING\n");	break;
		case RFP_ERROR_INTERNAL_ERROR:			printf("RFP_ERROR_INTERNAL_ERROR\n");	break;
		case RFP_ERROR_BAD_METAFILE:			printf("RFP_ERROR_BAD_METAFILE\n");	break;
		case RFP_ERROR_NO_LENGTH:				printf("RFP_ERROR_NO_LENGTH\n");	break;

		case SXML_ERROR_EOF:					printf("SXML_ERROR_EOF\n");	break;
		case SXML_ERROR_OUT_OF_MEMORY:			printf("SXML_ERROR_OUT_OF_MEMORY\n");	break;
		case SXML_ERROR_SYNTAX:					printf("SXML_ERROR_SYNTAX\n");	break;
		case SXML_ERROR_BAD_TAG:				printf("SXML_ERROR_BAD_TAG\n");	break;
		case SXML_ERROR_BAD_ATTRIBUTE:			printf("SXML_ERROR_BAD_ATTRIBUTE\n");	break;
		case SXML_ERROR_BAD_ENTITY:				printf("SXML_ERROR_BAD_ENTITY\n");	break;
		case SXML_ERROR_UNKNOWN_STATE:			printf("SXML_ERROR_UNKNOWN_STATE\n");	break;
		default:	printf("Unknown error %d\n",result);
		}
}
