/*--------------------------------------------------------------------------------

	SXML_Errors.h

	Copyright (c) 2002, Raritan Computer, Inc.

	Error codes for all SXML related classes

--------------------------------------------------------------------------------*/

#ifndef _SXML_ERROR_H_
#define	_SXML_ERROR_H_

//----------------------------------------
//				Equates
//----------------------------------------

	// SXML Error Codes

enum	SXML_Error
{
	SXML_NO_ERROR				= 0,	// No Error
	SXML_ERROR_EOF				= -1001,// EOF was reach prematurely
	SXML_ERROR_OUT_OF_MEMORY	= -1002,// Memory Allocation Error
	SXML_ERROR_SYNTAX			= -1003,// General parse error
	SXML_ERROR_BAD_TAG			= -1004,// An invalid tag name
	SXML_ERROR_BAD_ATTRIBUTE	= -1005,// An invalid attribute name
	SXML_ERROR_BAD_ENTITY		= -1006,// An entity (macro) was not recognized
	SXML_ERROR_UNKNOWN_STATE	= -1007,// Unknown helper state
	SXML_ERROR_XPATH_SYNTAX		= -1008,// XPath syntax error
	SXML_ERROR_XPATH_NULL_SET	= -1009,// XPath resulted in a null node set
	SXML_ERROR_DB_CORRUPT		= -1010,// The database contained an unknown node type
	SXML_ERROR_PARAMETER		= -1011,// A parameter was missing or invalid

	SXML_ERROR_NOT_FOUND		= -9999	// Requested element was not found (internal)
};

#endif
