/*
 * memory allocation algorithms that work on a buffer similar
 * as libc's malloc works on the heap
 *
 * (c) 2004 Peppercon AG
 * tbr@peppercon.de
 */

#ifndef _PP_BALLOC_H
#define _PP_BALLOC_H

#include <pp/mallocator.h>

/*
 * Flags. The integrity value is used as an arbitrary value to fill the flags.
 */
#define PP_B_INTEGRITY		0x8124000  /* Integrity value */
#define PP_B_INTEGRITY_MASK	0xFFFF000  /* Integrity mask */
#define PP_B_USE_MALLOC		0x1	   /* Okay to use malloc if required */
#define PP_B_USER_BUF		0x2	   /* User supplied buffer for mem */

pp_mallocator_t* pp_bnew(void* buf, size_t bufsize, int flags);
pp_mallocator_t* pp_bnew2(void* buf, size_t bufsize, int flags,
			  void  (*lock)(pp_mallocator_t* a),
			  void  (*unlock)(pp_mallocator_t* a),
			  void  (*mutex_init)(pp_mallocator_t* a,
					      pp_mutex_t* m,
					      pp_mutex_kind_t k));

#ifdef PP_B_STATS
void pp_bstats(pp_mallocator_t* a, void (*writefn)(char *fmt, ...));
#endif /* PP_B_STATS */

#endif /* _PP_BALLOC_H */
