/**
 * \file dlist.h
 *
 * Description: Double Linked List
 *
 * (c) 2004 Peppercon AG, Ralf Guenther <rgue@peppercon.de>
 */

#ifndef __DLIST_H__
#define __DLIST_H__

typedef struct dlist_s dlist_t;
typedef struct dlist_iter_s dlist_iter_t;

dlist_t* dlist_new(void (*delelem)(void*));
void dlist_delete(dlist_t* l);

int dlist_count(const dlist_t* l);
void* dlist_get(const dlist_t* l, const dlist_iter_t* it);
dlist_iter_t* dlist_find(const dlist_t* l, const void* e);

dlist_iter_t* dlist_insert(dlist_t* l, dlist_iter_t* succ, void* e);
void* dlist_remove(dlist_t* l, dlist_iter_t* it);
dlist_iter_t* dlist_erase(dlist_t* l, dlist_iter_t* it);
void dlist_clear(dlist_t* l);

dlist_iter_t* dlist_first(const dlist_t* l);
dlist_iter_t* dlist_last(const dlist_t* l);
dlist_iter_t* dlist_next(const dlist_t* l, const dlist_iter_t* it);
dlist_iter_t* dlist_prev(const dlist_t* l, const dlist_iter_t* it);

dlist_iter_t* dlist_push_back(dlist_t* l, void* e);
dlist_iter_t* dlist_push_front(dlist_t* l, void* e);
void* dlist_pop_back(dlist_t* l);
void* dlist_pop_front(dlist_t* l);

#endif /* __DLIST_H__ */
