/*
 * error handling:
 * in case a lib or a module needs extended errnos
 * (i.e. it is not happy with what's availble with std. errnos,
 * should rarely be the case) it may request 'em. Extended
 * errnos are also stored in the system errno but take the upper 16 bit.
 * In order to provide unique error numbers across multiple
 * libs and modules, any lib or module needs to register with
 * the base lib and provides a pointer to its error_string function
 * and receives a range of error numbers.
 * Any errno, either system or extended, should be converted to a
 * descriptive string using pp_error_string()
 */

#ifndef _PP_ERROR_H
#define _PP_ERROR_H

#ifdef __cplusplus
extern "C" {
#endif

const char* pp_error_string(int error);
int pp_register_errnos(int no, const char* (*error_string)(int error));
void pp_unregister_errnos(int range_start);

/* please use the macros PP_SUCCED() and PP_FAILED() as defined below */
#define PP_ERR -1 /* default return value of a function indicating an error */
#define PP_SUC  0 /*     default return value of a function indicating success */

#define PP_SUCCED(x) ((x) == PP_SUC)
#define PP_FAILED(x) ((x) != PP_SUC)

#ifdef __cplusplus
}
#endif

#endif
