#ifndef _PP_HASH_H
#define _PP_HASH_H

#include <errno.h>
#include <pp/win32.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _pp_hash_t pp_hash_t;
typedef struct _pp_hash_entry_t pp_hash_entry_t;
typedef struct {
    unsigned int next_index;
    pp_hash_entry_t * next_entry;
} pp_hash_iterator_t;

typedef void (*pp_hash_elem_free_func_t)(void*);

#define PP_HASH_REPLACE  1
#define PP_HASH_PRESERVE 0
    
extern pp_hash_t * pp_hash_create(size_t size);
extern void pp_hash_delete(pp_hash_t * hash);
extern void pp_hash_clear(pp_hash_t * hash);
extern void * pp_hash_get_entry(pp_hash_t * hash, const char * name);
static inline int
pp_hash_get_entry_as_int(pp_hash_t * hash, const char * name) {
    void* c = pp_hash_get_entry(hash, name);
    return (int)c;
}
extern int pp_hash_get_entry2(pp_hash_t* h, const char* name, void** value);
extern int pp_hash_set_entry_gently(pp_hash_t * h, int overwrite,
				    const char * name,  void * content,
				    pp_hash_elem_free_func_t free_content_fn);
static inline int
pp_hash_set_entry(pp_hash_t * hash, const char * name, void * content,
		  pp_hash_elem_free_func_t free_content_fn) {
    return pp_hash_set_entry_gently(hash, PP_HASH_REPLACE, name, content,
				    free_content_fn);
}
static inline int
pp_hash_set_entry_as_int(pp_hash_t * hash, const char * name, int content) {
    return pp_hash_set_entry_gently(hash, PP_HASH_REPLACE, name,
				    (void*)content, NULL);
}
extern void pp_hash_rehash_entry(pp_hash_t * h, const char * name,
				 const char * new_name);
extern void pp_hash_delete_entry(pp_hash_t * hash, const char * name);

extern const char * pp_hash_get_first_key(pp_hash_t * hash);
extern const char * pp_hash_get_next_key(pp_hash_t * hash);
extern const char * pp_hash_get_first_key_r(pp_hash_t * hash, pp_hash_iterator_t * it);
extern const char * pp_hash_get_next_key_r(pp_hash_t * hash, pp_hash_iterator_t * it);

extern void * pp_hash_get_first_entry(pp_hash_t * hash);
extern void * pp_hash_get_next_entry(pp_hash_t * hash);
extern void * pp_hash_get_first_entry_r(pp_hash_t * hash, pp_hash_iterator_t * it);
extern void * pp_hash_get_next_entry_r(pp_hash_t * hash, pp_hash_iterator_t * it);

extern unsigned int pp_hash_get_entry_count(pp_hash_t * h);
extern int pp_hash_serialize(pp_hash_t * h, char * buf, size_t buf_size);
extern int pp_hash_deserialize(pp_hash_t * h, char * buf, size_t buf_size);

extern void pp_hash_get_first_key_and_content(pp_hash_t * h, 
                                              char **key, void **content);
extern void pp_hash_get_next_key_and_content(pp_hash_t * h, 
                                             char **key, void **content);
extern void pp_hash_get_first_key_and_content_r(pp_hash_t * h, pp_hash_iterator_t * it,
                                                char **key, void **content);
extern void pp_hash_get_next_key_and_content_r(pp_hash_t * h, pp_hash_iterator_t * it,
                                               char **key, void **content);

/* integer hash variant */
/* note that key can be 0 */
typedef struct _pp_hash_t pp_hash_i_t;

extern pp_hash_i_t * pp_hash_create_i(size_t size);
extern void pp_hash_delete_i(pp_hash_i_t * hash);
extern void pp_hash_clear_i(pp_hash_i_t * hash);
extern void * pp_hash_get_entry_i(pp_hash_i_t * hash, unsigned int name);
static inline int
pp_hash_get_entry_i_as_int(pp_hash_i_t * hash, unsigned int name) {
    void* c = pp_hash_get_entry_i(hash, name);
    return (int)c;
}
extern int pp_hash_set_entry_i(pp_hash_i_t * hash, unsigned int name, void * content, pp_hash_elem_free_func_t free_content_fn);
static inline int
pp_hash_set_entry_i_as_int(pp_hash_i_t * hash, unsigned int name, int content) {
    return pp_hash_set_entry_i(hash, name, (void*)content, NULL);
}
extern void pp_hash_rehash_entry_i(pp_hash_i_t * h, unsigned int name, const unsigned int new_name);
extern void pp_hash_delete_entry_i(pp_hash_i_t * hash, unsigned int name);

/* warning: this iterator cannot be used if key=0 is in the hash; to be implemented if needed */
extern unsigned int pp_hash_get_first_key_i(pp_hash_i_t * hash);
extern unsigned int pp_hash_get_next_key_i(pp_hash_i_t * hash);

extern void * pp_hash_get_first_entry_i(pp_hash_i_t * hash);
extern void * pp_hash_get_next_entry_i(pp_hash_i_t * hash);
extern unsigned int pp_hash_get_entry_count_i(pp_hash_i_t * h);

#ifdef __cplusplus
}
#endif

#endif /* _PP_HASH_H */
