/*
 * This is a tweak of the standard malloc/realloc behaviour.
 * We have changed malloc and realloc to be weak symbol aliases
 * to the original functions renamed to __malloc and __realloc
 * in u-libc. This way we can redefine these functions here such
 * that they will abort the process.
 *
 * tbr@peppercon.de
 */
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>

static char* out_of_mem_msg = "Out of Memory!\n";

void* malloc (size_t size) {
    void* ret;
    if (NULL == (ret = __malloc(size)) && size > 0) {
	puts(out_of_mem_msg);
	abort();
    }
    return ret;
}

void* realloc (void* ptr, size_t size) {
    void* ret;
    if (NULL == (ret = __realloc(ptr, size)) && size > 0) {
	puts(out_of_mem_msg);
	abort();
    }
    return ret;
}
