/*
 * Implements the config update notification on pemx
 *
 * Author: Thomas Breitfeld <thomas@peppercon.de>
 * Copyright 2002 Peppercon AG
 */
#include <errno.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <assert.h>
#include <pp/base.h>

/*
 * queue and msg constants
 */
#define PP_LDMSG_UPDATE_QUEUE_KEY     0x99
#define PP_LDMSG_UPDATE_QUEUE_RIGHTS  0x1ff

/*
 * Config msg vars
 */
#define PP_CFGMSG_UPDATE_MSG_TAG      2

static int pp_msg_getqueue(void) {
    int msgq;
    msgq = msgget(PP_LDMSG_UPDATE_QUEUE_KEY,
		  PP_LDMSG_UPDATE_QUEUE_RIGHTS | IPC_CREAT);
    return msgq;
}

int pp_cfgmsg_update(void) {
    int que, ret;
    struct msgbuf msg = {
	PP_CFGMSG_UPDATE_MSG_TAG,
	{ 'a' }// just something
    };

    if(0 > (que = pp_msg_getqueue())) {
	return -1;
    }

    while(0 > (ret = msgsnd(que, &msg, sizeof(msg.mtext), 0))
	  && errno != EINTR);
    
    return ret;
}
