#include <assert.h>
#include <string.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <openssl/evp.h>
#include <pp/bio.h>
#include <pp/bio_internal.h>

#ifdef PP_FEAT_ESB2_TPT
#include <esb2_tpt.h>
#define ESB2_TPT_CHAN 1
#endif

int
pp_bio_get_peer_name(BIO * bio, char * ip_buf, size_t ip_buf_size)
{
    struct sockaddr_in6 addr;
    socklen_t addr_len = sizeof(struct sockaddr_in6);
    char * colon, * src, * dst;
    int fd;

    if (bio == NULL || (fd = BIO_get_fd(bio, NULL)) == -1) goto err;

#ifdef PP_FEAT_ESB2_TPT
    if (BIO_method_type(bio) == BIO_TYPE_PP_ESB2_TPT) {
        esb2_tpt_ioctl_tpt_stat_t tpt_stat = { .chan = ESB2_TPT_CHAN, };

        if (esb2_tpt_ioctl_get_tpt_stat(fd, &tpt_stat) < 0
         || tpt_stat.status != ESB2_TPT_STAT_CONNECTED) goto err;

        snprintf(ip_buf, ip_buf_size, "%d.%d.%d.%d",
            tpt_stat.remote_ip[0], tpt_stat.remote_ip[1],
            tpt_stat.remote_ip[2], tpt_stat.remote_ip[3]);

        return 0;
    }
#endif /* PRODUCT_INTELDC */

    if (getpeername(fd, (struct sockaddr *)&addr, &addr_len) == -1)
	goto err;

    if (addr.sin6_family == AF_INET6) {
	if (inet_ntop(AF_INET6, &addr.sin6_addr, ip_buf, ip_buf_size) == NULL)
	    goto err;
	if (IN6_IS_ADDR_V4MAPPED(&addr.sin6_addr) &&
	    (colon = strrchr(ip_buf, ':')) != NULL) {

	    // Overlapping alert! We should not use strcpy!
	    src = colon+1;
	    dst = ip_buf;
	    while (*src) *dst++ = *src++;
	    *dst = '\0';
	}
    } else if (inet_ntop(AF_INET, &((struct sockaddr_in *)&addr)->sin_addr,
			 ip_buf, ip_buf_size) == NULL) {
	goto err;
    }

    return 0;

 err:
    snprintf(ip_buf, ip_buf_size, "0.0.0.0");
    return -1;
}

int
pp_bio_set_md(BIO * bio, const EVP_MD * md)
{
    EVP_MD_CTX * ctx = bio->ptr;
    int ret;

    assert(BIO_method_type(bio) == BIO_TYPE_MD);

    ret = EVP_DigestInit_ex(ctx, md, NULL);
    if (ret > 0) bio->init = 1;
    return ret;
}
