%{
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <pp/cd.h>

#define YYENABLE_NLS 0
#define YYINCLUDED_STDLIB_H 1
#define YYLTYPE_IS_TRIVIAL 0
#define YYERROR_VERBOSE
#define YYDEBUG 1
%}

%debug

%union {
    int                      number;
    char*                    string;
    pp_cd_type_list_t*       types;
    pp_cd_enumerator_list_t* enums;
    pp_cd_proplist_t*        props;
    pp_cd_taglist_t*         tags;
    pp_cd_value_expr_list_t* values;
    pp_cd_cfg_key_t*         key;
    pp_cd_quali_cfg_key_t*   qualikey;
    pp_cd_as_id_t            sym;
    pp_cd_as_enumerator_t*   enumerator;
    pp_cd_as_property_t*     property;
    pp_cd_as_cd_t*           cd;
    pp_cd_as_section_t*      section;
    pp_cd_as_type_t*         type;
    pp_cd_as_value_expr_t*   value;
    pp_cd_as_fkt_decl_t*     fkt;
}

%{
extern pp_cd_as_cd_t* pp_cd_as_yy_cd;
extern int pp_cd_yy_pos;
int pp_cd_yylex   (void);
static void print_token_value (FILE *, int, YYSTYPE);
#define YYPRINT(file, type, value) print_token_value (file, type, value)
extern int pp_cd_yyerror (const char* text);
%}

%token              BOOLEAN_KW INT_KW STRING_KW
%token              ENUM_KW STRUCT_KW CHOICE_KW VECTOR_KW
%token              FKTDECL_KW TYPE_KW TYPES_KW CONFIGS_KW VALUES_KW
%token <number>     INT_LIT BOOLEAN_LIT
%token <string>     ID STRING_LIT

%type  <string>     qualified_id
%type  <sym>        fundamental_type
%type  <cd>         config_desc
%type  <section>    config_section
%type  <types>      type_decl_seq fkt_param_list
%type  <type>       type_decl basic_type_decl simple_type
%type  <type>       fkt_param basic_fkt_param
%type  <type>       vector_templ_type string_templ_type int_templ_type
%type  <enums>      enumerator_list
%type  <enumerator> enumerator
%type  <props>      property_list
%type  <property>   property text_property tag_property
%type  <tags>       tag_list
%type  <values>     assignment_expr_seq value_expr_list
%type  <value>      assignment_expr value_expr
%type  <fkt>        fkt_decl
%type  <key>        cfg_key
%type  <qualikey>   qualified_cfg_key

%%

config_desc:        config_section {
                      $$ = pp_cd_as_create_cd(pp_cd_malloc, pp_cd_yy_pos);
		      pp_cd_as_merge_cd_section($$, $1);
		      pp_cd_as_destroy(pp_cd_malloc, (pp_cd_as_t*)$1);
		      pp_cd_as_yy_cd = $$;
                    }
                  | config_desc config_section {
		      $$ = pp_cd_as_merge_cd_section($1, $2);
		      pp_cd_as_destroy(pp_cd_malloc, (pp_cd_as_t*)$2);
		      pp_cd_as_yy_cd = $$;
		    }
	          ;

config_section:     TYPES_KW '{' type_decl_seq '}'';' {
                      $$ = pp_cd_as_create_section(pp_cd_malloc, pp_cd_yy_pos,
						   AS_SECTION_TYPES, $3);
                    }
                  | CONFIGS_KW '{' type_decl_seq '}'';' {
		      $$ = pp_cd_as_create_section(pp_cd_malloc, pp_cd_yy_pos,
						   AS_SECTION_CONFIGS, $3);
		    }
                  | VALUES_KW '{' assignment_expr_seq '}'';' {
		      $$ = pp_cd_as_create_section(pp_cd_malloc, pp_cd_yy_pos,
						   AS_SECTION_VALUES, $3);
		    }
                  ;

type_decl_seq:      type_decl ';' {
                      $$ = vector_new_with_alloc(NULL, 100,
				       (vector_elem_del_func)pp_cd_as_destroy,
						 pp_cd_malloc);
		      vector_add($$, $1);
                    }
	          | type_decl_seq type_decl ';' {
		      $$ = $1;
		      vector_add($$, $2);
		    }
	          ;

type_decl:          basic_type_decl 
                  | basic_type_decl '{' property_list '}' {
                      assert(!$1->properties);
                      $1->properties = $3;
                      $$ = $1;
                    }
                  | basic_type_decl error { yyerrok; }
                  ;

basic_type_decl:    ID ':' simple_type {
                      assert(!$3->name);
                      $3->name = $1;
                      $$ = $3;
                    }
                  | ID ':' qualified_id {
                      $$ = pp_cd_as_create_alias(pp_cd_malloc, pp_cd_yy_pos,
						 $1, $3);
                    }
                  | ID '<' TYPE_KW ID '>'':' vector_templ_type {
                      $$ = pp_cd_as_create_vector_tmpl_spec(pp_cd_malloc,
							    pp_cd_yy_pos,
							    $1, $4, $7);
		    }
                  | ID ':' qualified_id '<' qualified_id '>' {
	              $$ = pp_cd_as_create_vector_tmpl_inst(pp_cd_malloc,
							    pp_cd_yy_pos,
							    $1, $3, $5);
                    }
                  ;

simple_type:        BOOLEAN_KW {
		      $$ = pp_cd_as_create_type(pp_cd_malloc, pp_cd_yy_pos,
						NULL,
						AS_TYPE_BOOL);
		    }
		  | FKTDECL_KW {
		      $$ = pp_cd_as_create_type(pp_cd_malloc, pp_cd_yy_pos,
						NULL,
						AS_TYPE_FKT);
		    }
		  | ENUM_KW '{' enumerator_list '}' {
		      $$ = pp_cd_as_create_enum(pp_cd_malloc, pp_cd_yy_pos,
						NULL, $3);
		    }
		  | CHOICE_KW '<' qualified_id '>''{' type_decl_seq '}' {
		      $$ = pp_cd_as_create_choice_tmpl(pp_cd_malloc,
						       pp_cd_yy_pos, NULL,
						       $3, $6);
		    }
		  | STRUCT_KW '{' type_decl_seq '}' {
		      $$ = pp_cd_as_create_struct(pp_cd_malloc, pp_cd_yy_pos,
						  NULL, $3);
		    }
                  | string_templ_type
		  | int_templ_type
                  | vector_templ_type
		  ;

string_templ_type:  STRING_KW '<' STRING_LIT ',' INT_LIT ',' INT_LIT '>' {
		      $$ = pp_cd_as_create_string_tmpl(pp_cd_malloc,
						       pp_cd_yy_pos, NULL,
						       $3, $5, $7);
		    }
                  ;

int_templ_type:     INT_KW '<' INT_LIT ',' INT_LIT '>' {
		      $$ = pp_cd_as_create_int_tmpl(pp_cd_malloc,
						    pp_cd_yy_pos, NULL,
						    $3, $5);
		    }
                  ;

// vector_templ_type:  VECTOR_KW '<' vector_type ',' fundamental_type ',' INT_LIT '>' 
// whereas vector_type = unnamed_alias (= qualified_id) | BOOLEAN_KW | FKTDECL_KW
vector_templ_type:  VECTOR_KW '<' qualified_id ',' fundamental_type ',' INT_LIT '>' {
		      $$ = pp_cd_as_create_vector_tmpl(pp_cd_malloc,
						       pp_cd_yy_pos, NULL,
						       $3, $5, $7);
		    }
		  ;

enumerator_list:    enumerator {
                      $$ = vector_new_with_alloc(NULL, 10,
				   (vector_elem_del_func)pp_cd_as_destroy,
						 pp_cd_malloc);
		      vector_add($$, $1);
                    }
                  | enumerator_list ',' enumerator {
		      $$ = $1;
		      vector_add($$, $3);
		    }
	          ;

enumerator:         ID {
		      $$ = pp_cd_as_create_enumerator(pp_cd_malloc,
						      pp_cd_yy_pos, $1);
		    }
		  | ID '{' property_list '}' {
		      $$ = pp_cd_as_create_enumerator(pp_cd_malloc,
						      pp_cd_yy_pos, $1);
		      $$->properties = $3;
		    }
                  | STRING_LIT {
		      $$ = pp_cd_as_create_enumerator(pp_cd_malloc,
						      pp_cd_yy_pos, $1);
		    }
		  | STRING_LIT '{' property_list '}' {
		      $$ = pp_cd_as_create_enumerator(pp_cd_malloc,
						      pp_cd_yy_pos, $1);
		      $$->properties = $3;
		    }
                  ;

property_list:      property {
                      $$ = vector_new_with_alloc(NULL, 10,
				      (vector_elem_del_func)pp_cd_as_destroy,
						 pp_cd_malloc);
		      vector_add($$, $1);
		    }
                  | property_list property {
		      $$ = $1;
		      vector_add($$, $2);
		    }
                  ;

property:           text_property ';'
                  | text_property error { yyerrok; }
                  | tag_property ';'
                  | tag_property error { yyerrok; }
                  ;

text_property:      ID ':' STRING_LIT {
                      pp_cd_property_value_t v;
                      v.text = $3;
                      $$ = pp_cd_as_create_property(pp_cd_malloc,
						    pp_cd_yy_pos, $1,
						    AS_PROPERTY_STRING, v);
                    }
                  ;

tag_property:       ID ':' tag_list {
                      pp_cd_property_value_t v;
                      v.tags = $3;
                      $$ = pp_cd_as_create_property(pp_cd_malloc,
						    pp_cd_yy_pos, $1,
						    AS_PROPERTY_TAG, v);
                    }
                  ;

tag_list:           ID {
                      $$ = vector_new_with_alloc(NULL, 10, pp_free,
						 pp_cd_malloc);
		      vector_add($$, $1);
		    }
                  | tag_list ',' ID {
		      $$ = $1;
		      vector_add($$, $3);
		    }
                  ;

qualified_id:       ID
                  | qualified_id '.' ID {
                      $$ = pp_cd_qualified_id_add(pp_cd_malloc, $1, $3);
                      free($3);
		    }
                  ;

fundamental_type:   INT_KW     { $$ = AS_FUND_TYPE_INT; }
                  | STRING_KW  { $$ = AS_FUND_TYPE_STRING; }
                  ;

assignment_expr_seq: assignment_expr {
                      $$ = vector_new_with_alloc(NULL, 100,
				       (vector_elem_del_func)pp_cd_as_destroy,
						 pp_cd_malloc);
		      vector_add($$, $1);
		    }
                  | assignment_expr_seq assignment_expr {
		      $$ = $1;
		      vector_add($$, $2);
		    }
                  ;

assignment_expr:    qualified_cfg_key '=' value_expr ';' {
                      assert(!$3->qkey);
                      $3->qkey = $1;
                      $$ = $3;
                    }
                  ;

qualified_cfg_key:  cfg_key {
                      $$ = vector_new_with_alloc(NULL, 10, 
                                 (vector_elem_del_func)pp_cd_cfg_key_destroy, 
                                                 pp_cd_malloc);
		      vector_add($$, $1);
                    }
                  | qualified_cfg_key '.' cfg_key {
		      vector_add($$, $3);
		    }
                  ;

cfg_key:            ID {
                      pp_cd_cfg_key_idx_t k;
		      k.type = 0;
                      $$ = pp_cd_cfg_key_create(pp_cd_malloc, 
                                                AS_CFG_KEY_SCALAR, $1, k);
                    }
                  | ID '[' INT_LIT ']' {
                      pp_cd_cfg_key_idx_t k;
		      k.type = AS_FUND_TYPE_INT;
                      k.value.intidx = $3;
                      $$ = pp_cd_cfg_key_create(pp_cd_malloc, 
                                                AS_CFG_KEY_VECTOR, $1, k);
                    }
                  | ID '[' ID ']' {
                      pp_cd_cfg_key_idx_t k;
		      k.type = AS_FUND_TYPE_STRING;
                      k.value.stridx = $3;
                      $$ = pp_cd_cfg_key_create(pp_cd_malloc, 
                                                AS_CFG_KEY_VECTOR, $1, k);
		    }
                  ;

value_expr:         INT_LIT {
                      pp_cd_literal_value_t v;
                      v.intval = $1;
                      $$ = pp_cd_as_create_value_expr(pp_cd_malloc,
						      pp_cd_yy_pos, NULL,
						      AS_EXPR_INT_LITERAL, v);
                    }
                  | BOOLEAN_LIT {
                      pp_cd_literal_value_t v;
                      v.boolval = $1;
                      $$ = pp_cd_as_create_value_expr(pp_cd_malloc,
						      pp_cd_yy_pos, NULL,
						      AS_EXPR_BOOL_LITERAL, v);
                    }
                  | STRING_LIT {
                      pp_cd_literal_value_t v;
                      v.stringval = $1;
                      $$ = pp_cd_as_create_value_expr(pp_cd_malloc,
						      pp_cd_yy_pos, NULL,
						      AS_EXPR_STRING_LITERAL,
						      v);
                    }
                  | ID {
                      pp_cd_literal_value_t v;
                      v.stringval = $1;
                      $$ = pp_cd_as_create_value_expr(pp_cd_malloc,
						      pp_cd_yy_pos, NULL,
						      AS_EXPR_ENUM_LITERAL,
						      v);
                    }
                  | fkt_decl {
                      pp_cd_literal_value_t v;
                      v.fktval = $1;
                      $$ = pp_cd_as_create_value_expr(pp_cd_malloc,
						      pp_cd_yy_pos, NULL,
						      AS_EXPR_FKT_DECL, v);
                    }
                  | ID '{' value_expr_list '}' {
                      pp_cd_literal_value_t v;
                      v.choiceval.choice = $1;
                      v.choiceval.choicelist = $3;
                      $$ = pp_cd_as_create_value_expr(pp_cd_malloc,
						      pp_cd_yy_pos, NULL,
						   AS_EXPR_CHOICE_LITERAL, v);
                    }
                  | ID '{' '}' {
                      pp_cd_literal_value_t v;
                      v.choiceval.choice = $1;
                      v.choiceval.choicelist = vector_new_with_alloc(NULL, 1,
					(vector_elem_del_func)pp_cd_as_destroy,
					       pp_cd_malloc);
                      $$ = pp_cd_as_create_value_expr(pp_cd_malloc,
						      pp_cd_yy_pos, NULL,
						   AS_EXPR_CHOICE_LITERAL, v);
                    }
                  | '{' value_expr_list '}' {
                      pp_cd_literal_value_t v;
                      v.listval = $2;
                      $$ = pp_cd_as_create_value_expr(pp_cd_malloc,
						      pp_cd_yy_pos, NULL,
						      AS_EXPR_VALUE_LIST, v);
                    }
                  ;

value_expr_list:    value_expr {
                      $$ = vector_new_with_alloc(NULL, 10,
					(vector_elem_del_func)pp_cd_as_destroy,
						 pp_cd_malloc);
		      vector_add($$, $1);
		    }
                  | value_expr_list ',' value_expr {
		      $$ = $1;
		      vector_add($$, $3);
		    }
                  | assignment_expr_seq
                  ;

fkt_decl:           ID '(' ')'{
                      $$ = pp_cd_as_create_fkt_decl(pp_cd_malloc,
						    pp_cd_yy_pos, $1, NULL, NULL);
                    }
		  | ID '(' ')' '{' property_list '}' {
                      $$ = pp_cd_as_create_fkt_decl(pp_cd_malloc,
						    pp_cd_yy_pos, $1, NULL, $5);
                    }
		  | ID '(' fkt_param_list ')' {
                      $$ = pp_cd_as_create_fkt_decl(pp_cd_malloc,
						    pp_cd_yy_pos, $1, $3, NULL);
                    }
		  | ID '(' fkt_param_list ')' '{' property_list '}' {
                      $$ = pp_cd_as_create_fkt_decl(pp_cd_malloc,
						    pp_cd_yy_pos, $1, $3, $6);
                    }
                  ;

fkt_param_list:     fkt_param {
                      $$ = vector_new_with_alloc(NULL, 10,
				    (vector_elem_del_func)pp_cd_as_destroy,
						 pp_cd_malloc);
		      vector_add($$, $1);
		    }
                  | fkt_param_list ',' fkt_param {
		      $$ = $1;
		      vector_add($$, $3);
		    }
                  ;

fkt_param:	  basic_fkt_param '{' property_list '}' {
                      assert(!$1->properties);
                      $1->properties = $3;
                      $$ = $1;
                    }
		  | basic_fkt_param
		  ;

basic_fkt_param:   ID ':' qualified_id {
                      $$ = pp_cd_as_create_alias(pp_cd_malloc,
						 pp_cd_yy_pos, $1, $3);
                    }
		  | ID ':' BOOLEAN_KW {
		      $$ = pp_cd_as_create_type(pp_cd_malloc, pp_cd_yy_pos,
						$1, AS_TYPE_BOOL);
		    }
                  ;

%%

static void print_token_value (FILE *file, int type, YYSTYPE value) {
    switch (type) {
      case STRING_LIT:
      case ID:
	  fprintf (file, "%s", value.string);
	  break;
      case INT_LIT:
	  fprintf (file, "%d", value.number);
	  break;
      case BOOLEAN_LIT:
	  fprintf (file, "%s", value.number ? "true" : "false");
	  break;
      default:
	  fprintf (file, "na");
    }
}
