/*
 * standalone cdl parser's main function
 * used to check the base.cdl when installing fs-skeleton
 *
 * (c) 2004 Peppercon AG
 * tbr@peppercon.de
 */

#include <stdio.h>
#include <string.h>
#include <pp/cd.h>

#include "as_op_i18n_internal.h"

extern pp_cd_as_op_t pp_cd_as_op_i18n;

int main (int argc, char** argv) {
    pp_cd_as_cd_t* cd;
    char fn[255];
    int i, error = 0;
    char *app;
    
    if(!(argc == 3 || argc == 4))
        goto help;
    
    snprintf(fn, 255, "%s/%s", argv[1], argv[2]);
    if(NULL == (cd = pp_cd_parse_cdl(pp_mallocator_heap(), fn)))
        return -1;
    
    if(argc == 4) {
        /* parse config and generate enum defines */        
        FILE *i18n;
        
        snprintf(fn, 255, "%s/%s", argv[1], argv[3]);
        if((i18n = fopen(fn, "w")) == NULL) {
            printf("ERROR: could not open file %s\n", fn);
            error = -1;
        } else {
            i18n_ctx_t ctx;
            memset(&ctx, 0, sizeof(ctx));
            ctx.fp = i18n;
            
            pp_cd_execute_op((pp_cd_as_t*)cd, &pp_cd_as_op_i18n, (void*)&ctx);
            pp_cd_destroy_values(cd);
            
            fclose(i18n);
        }
    }
    
    pp_cd_destroy(cd);
    
    if(!error) {
        printf("checked cdl successfully\n");
    }
    
    return error;

 help:
    if((app = strrchr(argv[0], '/')) == NULL)
        app = argv[0];
    else
        ++app;
    i = strlen(app);
    assert(i < 256);
    memset(fn, ' ', 255);
    fn[i] = '\0';
    printf("syntax:\n");
    printf("%s fw_topdir cdl [i18n-file]\n", app);
    printf("%s fw_topdir:   path to firmware root "
           "(e.g. src/eric_firmware)\n", fn);
    printf("%s cdl:         relative path to cdl "
           "(e.g. fs-skeleton/etc/base.cdl)\n", fn);
    printf("%s i18n-file: optional relative path to auto generated i18n "
           "text file (e.g. i18n.txt)\n", fn);
    
    return -1;
}

