/*
 * simple cache to store acls against their user id
 *
 * Author: Thomas Breitfeld <thomas@peppercon.de>
 * Copyright 2003 Peppercon AG
 */

#include <pp/base.h>
#include "pp/cfg.h"
#include "acl_cache.h"

static pp_acl_t* (*acl_get_fkt)(int);

void acl_cache_init(pp_acl_t*(*acl_get)(int)) {
    acl_get_fkt = acl_get;
}

pp_acl_t* acl_cache_get(pp_hash_t* cache, int gid) {
    pp_acl_t* acl;
    
    /* if acl not in cache, get new acl and cache it, if successful */
    if(NULL == (acl = pp_hash_get_entry_i(cache, gid)) &&
       NULL != (acl = acl_get_fkt(gid))) {
	pp_hash_set_entry_i(cache, gid, acl, (void(*)(void*))pp_acl_destroy);
    }
    return acl;
}

void acl_cache_set(pp_hash_t* cache, int gid, pp_acl_t *acl) {
    pp_hash_set_entry_i(cache, gid, acl, (void(*)(void*))pp_acl_destroy);
}

void acl_cache_clear(pp_hash_t* cache, int gid) {
    pp_hash_delete_entry_i(cache, gid);
}

