#include <pp/cim.h>
#include <pp/cimTypes.h>
#include <pp/cim_provider.h>
#include "cim_common.h"
#include "instance.h"
#include "provider_enabledlogicalelement.h"

#include "valmap_enabledlogicalelement.h"

// class properties
// { <name>, <type>, <array>, <valmap>, <key>, <priv>, <required>, <writable>, { <null>, { <defvalue> } } }
static pp_cim_property_t properties[] =
{
    {"EnabledState", PP_CIM_UNSIGNED, 0, enabledstate_valmap, 0, 0, 1, 0, {0, {.unsigned_int = 5}}},
    {"OtherEnabledState", PP_CIM_STRING_CONST, 0, NULL, 0, 0, 0, 0, {1, {0}}},
    {"RequestedState", PP_CIM_UNSIGNED, 0, requestedstate_valmap, 0, 0, 0, 0, {0, {.unsigned_int = 5}}},
    {"EnabledDefault", PP_CIM_UNSIGNED, 0, enableddefault_valmap, 0, 0, 0, 0, {0, {.unsigned_int = 2}}},
//    { "TimeOfLastStateChange", PP_CIM_DATETIME, 0, NULL,                  0, 0, 0, 0, { 1, { 0 }                 } },
    {.name = NULL}
};

// class description
pp_cim_class_desc_t pp_cim_enabledlogicalelement_desc =
{
    .cim_name = "CIM_EnabledLogicalElement",
    .ufct = NULL,
    .dispname = "CIM Enabled Logical Element",
    .superclass = "CIM_LogicalElement",
    .assoc = 0,
    .properties = properties,
    .methods = NULL, // no methods
    .update = NULL,
    .clp_update = NULL
};

