#include <pp/cim.h>
#include <pp/cimTypes.h>
#include <pp/cim_provider.h>
#include "cim_common.h"
#include "instance.h"
#include "provider_common.h"
#include "provider_logicaldevice.h"

// provider API functions
static pp_cim_provider_t provider =
{
    .deinit = provider_common_deinit,
    .update = provider_common_update,
    .commit = provider_common_commit,
    .authorize = provider_common_authorize,
    .get_property = provider_common_get_property,
    .set_property = provider_common_set_property,
    .get_properties = provider_common_get_properties,
    .set_properties = provider_common_set_properties,
    .get_method = provider_common_get_method,
    .call_method = provider_common_call_method,
    .clp_map_reset = pp_cim_logicaldevice_map_reset,
    .clp_map_set = NULL, // 'set' command not supported
    .clp_map_start = NULL, // 'start' command not supported
    .clp_map_stop = NULL // 'stop' command not supported
};

// class properties
// { <name>, <type>, <array>, <valmap>, <key>, <priv>, <required>, <writable>, { <null>, { <defvalue> } } }
static pp_cim_property_t properties[] =
{
    {"SystemCreationClassName", PP_CIM_STRING_CONST, 0, NULL, 1, 0, 1, 0, {0, {.string_const = "CIM_ComputerSystem"}}},
    {"SystemName", PP_CIM_STRING_CONST, 0, NULL, 1, 0, 1, 0, {0, {.string_const = "Management"}}},
    {"CreationClassName", PP_CIM_STRING_CONST, 0, NULL, 1, 0, 1, 0, {1, {0}}},
    {"DeviceID", PP_CIM_STRING_CONST, 0, NULL, 1, 0, 1, 0, {1, {0}}},
    // from CIM_ManagedElement:
    {"ElementName", PP_CIM_STRING_CONST, 0, NULL, 0, 0, 0, 0, {1, {0}}},
    // from CIM_ManagedSystemElement:
    {"Name", PP_CIM_STRING_CONST, 0, NULL, 0, 0, 1, 0, {1, {0}}},
    {.name = NULL}
};

// class methods
// { <name>, <result>, <num_args>, <args>, <priv>, <defptr> }
static pp_cim_method_t methods[] =
{
    {"Reset", PP_CIM_UNSIGNED, 0, NULL, 0, NULL},
    {.name = NULL}
};

// class description
pp_cim_class_desc_t pp_cim_logicaldevice_desc =
{
    .cim_name = "CIM_LogicalDevice",
    .ufct = NULL,
    .dispname = "CIM Logical Device",
    .superclass = "CIM_ManagedElement", // should be CIM_EnabledLogicalElement
    .assoc = 0,
    .properties = properties,
    .methods = methods,
    .update = NULL,
    .clp_update = NULL
};

// Create a new CIM_LogicalDevice instance
pp_cim_instance_t *pp_cim_logicaldevice_new()
{
    pp_cim_instance_t *i = pp_cim_instance_new("CIM_LogicalDevice", &provider);
    return i;
}

pp_cim_method_call_t *pp_cim_logicaldevice_map_reset(pp_cim_instance_t *instance)
{
    pp_cim_methodptr_t *methodptr;
    pp_cim_method_call_t *call;
    methodptr = provider_common_get_method(instance, "Reset");
    call = pp_cim_method_call_new(methodptr, instance);
    return call;
}

