/*
 * PP_Outlet class implementation
 *
 * Note: For demonstration purposes only, this class is not covered
 *       by any spec.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <pp/cim.h>
#include <pp/cimTypes.h>
#include <pp/cim_provider.h>
//#include <pp/cfg.h>
#include <pp_gpio.h>
#include <pp/ipmi.h>
#include <pp/um.h>
#include "cim_common.h"
#include "instance.h"
#include "provider_common.h"
#include "provider_outlet.h"
#include "valmap_outlet.h"
#include "provider_dependency.h"
#include "namespace.h"
#include "provider_authorizedtarget.h"
#include "provider_authorizedsubject.h"
#include "provider_authorizedprivilege.h"

static void outlet_update(pp_cim_instance_t *instance);
static pp_cim_method_call_t *outlet_map_set(pp_cim_instance_t *instance,
    pp_clp_property_value_t *prop);
static int outlet_setpowerstate(pp_cim_instance_t *instance, vector_t *args,
    pp_cim_data_t *result);

// provider API functions
static pp_cim_provider_t provider =
{
    .deinit = provider_common_deinit,
    .update = outlet_update,
    .commit = provider_common_commit,
    .authorize = provider_common_authorize,
    .get_property = provider_common_get_property,
    .set_property = provider_common_set_property,
    .get_properties = provider_common_get_properties,
    .set_properties = provider_common_set_properties,
    .get_method = provider_common_get_method,
    .call_method = provider_common_call_method,
    .clp_map_reset = NULL, // 'reset' command not supported
    .clp_map_set = outlet_map_set,
    .clp_map_start = NULL, // 'start' command not supported
    .clp_map_stop = NULL // 'stop' command not supported
};

// class properties
// { <name>, <type>, <array>, <valmap>, <key>, <priv>, <required>, <writable>, { <null>, { <defvalue> } } }
static pp_cim_property_t properties[] =
{
    {"Name", PP_CIM_STRING_CONST, 0, NULL, 1, 0, 1, 0, {1, {0}}},
    {"powerState", PP_CIM_UNSIGNED, 0, outlet_valmap, 0, 0, 1, 1, {0, {.unsigned_int = 1}}},
    {.name = NULL}
};

// PP_Outlet::SetEnaboutlet() arguments
// { <name>, <type>, <array>, <valmap>, <in>, <out> }
static pp_cim_method_arg_t outlet_setpowerstate_args[] =
{
    {"powerState", PP_CIM_UNSIGNED, 0, outlet_valmap, 1, 0}
};

// class methods
// { <name>, <result>, <num_args>, <args>, <priv>, <defptr> }
static pp_cim_method_t methods[] =
{
    {"setPowerState", PP_CIM_VOID, 1, outlet_setpowerstate_args, 0, outlet_setpowerstate},
    {.name = NULL}
};

// class description
pp_cim_class_desc_t pp_cim_outlet_desc =
{
    .cim_name = "CIM_Outlet",
    .dispname = "OUTLET",
    .ufct = "outlet",
    .superclass = "CIM_ManagedElement",
    .assoc = 0,
    .properties = properties,
    .methods = methods,
    .update = NULL,
    .clp_update = NULL
};

// Create a new PP_Outlet instance
pp_cim_instance_t *pp_cim_outlet_new()
{
    pp_cim_instance_t *i = pp_cim_instance_new("CIM_Outlet", &provider);
    return i;
}

vector_t *pp_cim_outlet_discovery()
{
    // Get number of outlet
    char outletname[10];
    int no_outlet = 0;
    int i;

    pp_ipmi_return_t ipmi_ret;
    memset(&ipmi_ret, 0, sizeof(ipmi_ret));
    if (pp_ipmi_send_command(PP_IPMI_CMD_BMC, PP_IPMI_BMC_SUBCMD_INFO, NULL,
        &ipmi_ret, NULL, NULL)) {
        printf("IPMI: Error in sending BMC INFO command.\n");
        return NULL;
    } else {
        no_outlet = (ipmi_ret.data.bmc_info.product_id & 0xff00) >> 8;
        /* printf("Number of outlet: %ld %d\n",
           ipmi_ret.data.bmc_info.product_id, no_outlet); */
        pp_ipmi_cleanup_ret(&ipmi_ret);
    }


    pp_cim_instance_t *inst;
    pp_cim_data_t name, state;

    name.null = 0;
    state.null = 0;

    vector_t *result = vector_new(NULL, no_outlet, NULL);

    for (i = 0; i < no_outlet; i++) {
        inst = pp_cim_outlet_new();
        sprintf(outletname, "OUTLET%d", i + 1);
        name.types.string_const = outletname;
        state.types.unsigned_int = 1;
        provider_common_set_property(inst, "Name", name, 1);
        provider_common_set_property(inst, "powerState", state, 1);
        vector_add(result, inst);
    }
    return result;
}

static pthread_mutex_t cim_outlet_mutex;
/*
 * call back function
 */
int cfg_chg_outlet_user(pp_cfg_chg_ctx_t *ctx)
{
    pthread_mutex_lock(&cim_outlet_mutex);
    char *val;
    char comps[128] = "";
    char items[8][32];
    //printf("%s %d %d \n", __FUNCTION__, ctx->mode, ctx->chg_kind);

    unsigned int i, j;
    int itemno = 0;
    for (i = 0; i < vector_size(ctx->key_comp_vec); i++) {
        vector_t *v = vector_get(ctx->key_comp_vec, i);
        for (j = 0; j < vector_size(v); j++) {
            const char *comp = pp_cfg_get_key_comp_name_at_idx(v, j);
            itemno++;
            strncpy(items[itemno-1], comp, 31);

            strcat(comps, comp);
            strcat(comps, ".");
        }
    }
    // check
    if (itemno != 8)
        goto _exit;
    if (strlen(comps) == 0)
        goto _exit;
    if ((strcmp(items[1], "_e_") != 0) || (strcmp(items[3], "acl") != 0) ||
        (strcmp(items[4], "_e_") != 0) || (strcmp(items[6], "_e_") != 0) ||
        (strcmp(items[7], "0") != 0))
        goto _exit;

    unsigned int uid, outletid;
    uid = atoi(items[2]);
    outletid = atoi(items[5] + 7);

    comps[strlen(comps)-1] = 0;
    pp_cfg_get(&val, comps);
    printf("uid %d outletid %d %s\n", uid, outletid, val);

    pp_cim_outlet_set_privilege(uid, outletid, val);

_exit:
    pthread_mutex_unlock(&cim_outlet_mutex);

    return 0;
}

/*
 * uid: 	 >=1
 * outletid: >=0
 * AuthorizedPrivilege1 is for system, so the authorizedprivilege of the outlet is from 2~
 */
void pp_cim_outlet_set_privilege(unsigned int uid, unsigned int outletid, char *right)
{
    vector_t *authprivs, *accounts;

    if (uid < 1) {
        printf("Account ID is incorrect: %d\n", uid);
    }

    //printf("%s\n", __FUNCTION__);
    pp_cim_class_t *authprivclass = pp_cim_class_lookup("CIM_AuthorizedPrivilege");
    pp_cim_class_update(authprivclass);
    authprivs = pp_cim_get_instances(authprivclass);

    pp_cim_class_t *accountclass = pp_cim_class_lookup("CIM_Account");
    pp_cim_class_update(accountclass);
    accounts = pp_cim_get_instances(accountclass);

    pp_cim_instance_t *account = NULL, *authpriv = NULL;

    // FIXME: Maybe the index is incorrect.
    account = vector_get(accounts, uid - 1);
    //printf("account id=%d\n", account->instance_id);

    // FIXME: Maybe the index is incorrect.
    authpriv = vector_get(authprivs, outletid + 1);
    //printf("authpriv id=%d\n", authpriv->instance_id);

    pp_cim_class_t *sd = pp_cim_class_lookup("CIM_AuthorizedSubject");
    vector_t *v = pp_cim_get_instances(sd);

    int notfound = 1;
    unsigned int i;
    pp_cim_instance_t *p = NULL;
    for (i = 0; i < vector_size(v); i++) {
        p = vector_get(v, i);
        pp_cim_propval_t *pvp = provider_common_get_property(p, "Privilege");
        pp_cim_propval_t *pve = provider_common_get_property(p, "PrivilegedElement");
        if ((pvp->data.types.reference == authpriv) &&
            (pve->data.types.reference == account)) {
            notfound = 0;
            break;
        }
    }

    if (strcmp(right, "+allow") == 0) {
        if (notfound) {
            printf("add authorizedsubject\n");
            pp_cim_authorizedsubject_new(authpriv, account);
        }
    } else {
        if (!notfound && p != NULL) {
            printf("delete authorizedsubject\n");
            pp_cim_instance_unregister(p);
        }
    }

    vector_delete(v);
    pp_cim_class_release(sd);

    vector_delete(authprivs);
    vector_delete(accounts);
    pp_cim_class_release(authprivclass);
    pp_cim_class_release(accountclass);

}
/*

void pp_cim_outlet_set_privilege_old(char *accountid, char *outletid, char *right)
{
vector_t *authprivs, *accounts;
pp_cim_class_t *authprivclass = pp_cim_class_lookup("CIM_AuthorizedPrivilege");
pp_cim_class_update(authprivclass);
authprivs = pp_cim_get_instances(authprivclass);

pp_cim_class_t *accountclass = pp_cim_class_lookup("CIM_Account");
pp_cim_class_update(accountclass);
accounts = pp_cim_get_instances(accountclass);

pp_cim_instance_t *account = NULL, *authpriv = NULL;
unsigned int i;
for (i = 0; i < vector_size(accounts); i++) {
pp_cim_instance_t *a = vector_get(accounts, i);
pp_cim_propval_t *pv = pp_cim_get_property(a, "UserID");
if (pv->data.types.string == NULL)
continue;
if (strcmp(pv->data.types.string, accountid) == 0) {
account = a;
break;
}
}
if (account == NULL)
goto _exit;

unsigned int outlet_num;
outlet_num = atoi(outletid+7);
if (outlet_num >= vector_size(authprivs))
goto _exit;
authpriv = vector_get(authprivs, outlet_num + 1);
if (authpriv == NULL)
goto _exit;

pp_cim_class_t *sd = pp_cim_class_lookup("CIM_AuthorizedSubject");
vector_t *v = pp_cim_get_instances(sd);

int notfound = 1;
pp_cim_instance_t *p = NULL;
for (i = 0; i < vector_size(v); i++) {
p = vector_get(v, i);
pp_cim_propval_t *pvp = provider_common_get_property(p, "Privilege");
pp_cim_propval_t *pve = provider_common_get_property(p, "PrivilegedElement");
if ((pvp->data.types.reference == authpriv) &&
(pve->data.types.reference == account)) {
notfound = 0;
break;
}
}

if (strcmp(right,"+access") == 0) {
if (notfound) {
printf("add\n");
pp_cim_authorizedsubject_new(authpriv, account);
}
} else {
if (!notfound && p!= NULL) {
printf("delete %x\n", p);
pp_cim_instance_unregister(p);
}
}

vector_delete(v);
pp_cim_class_release(sd);

_exit:
vector_delete(authprivs);
vector_delete(accounts);
pp_cim_class_release(authprivclass);
pp_cim_class_release(accountclass);
}
*/

/*
 * Get the ACL to create the association of outlet and account
 *
 * @param system
 * @param accounts
 * @param outlets
 */
void pp_cim_outlet_privilege_discovery(pp_cim_instance_t *sys,
    vector_t *accounts, vector_t *outlets)
{
    pp_cim_instance_t *account;
    pp_cim_instance_t *outlet;
    pp_cim_instance_t *priv;
    pp_ipmi_parameter_t params;
    pp_ipmi_return_t ipmi_ret;
    unsigned int i;
    int j, ret, err;

    pthread_mutex_init(&cim_outlet_mutex, NULL);

    // register cfg change listener
    pp_cfg_add_change_listener(cfg_chg_outlet_user, "user");

    memset(&params, 0, sizeof(params));
    for (i = 0; i < vector_size(outlets); i++) {
        // new authorizedprivilege
        outlet = vector_get(outlets, i);
        priv = pp_cim_authorizedprivilege_new();
        pp_cim_add_instance(priv, sys);
        pp_cim_authorizedtarget_new(priv, sys);
        pp_cim_authorizedtarget_new(priv, outlet);

        memset(&ipmi_ret, 0, sizeof(ipmi_ret));
        params.data.oem_pp_rpc_get_recep_acl.receptacle = i;
        ret = pp_ipmi_send_command(PP_IPMI_CMD_OEM_PP_RPC,
            PP_IPMI_OEM_PP_RPC_GET_RECEPTACLE_ACL,
            &params, &ipmi_ret, &err, NULL);
        if (ret) {
            printf("IPMI failure: %s.\n", pp_ipmi_get_error_string(err));
            break;
        }
        /* printf("total: %d\n",
           ipmi_ret->data.oem_pp_rpc_get_recep_acl_rs.num_acl); */
        for (j = 0; j < ipmi_ret.data.oem_pp_rpc_get_recep_acl_rs.num_acl; j++) {
            unsigned char data = ipmi_ret.data.oem_pp_rpc_get_recep_acl_rs.acl[j];
            // printf("%d:%x\n", j, data);
            if (data & 0x80) {
                // allow
                if (data & 0x40) {
                    // privilege level
                } else {
                    // user id
                    int uid = data & 0x3f;
                    if (uid - 1 >= 0) {
                        account = vector_get(accounts, uid - 1);
                        pp_cim_authorizedsubject_new(priv, account);
                    }
                }
            }
        }
        pp_ipmi_cleanup_ret(&ipmi_ret);
    }
}

static void outlet_update(pp_cim_instance_t *instance)
{
    pp_cim_data_t data;
    int err, ret;
    pp_ipmi_parameter_t params;
    pp_ipmi_return_t ipmi_ret;

    provider_common_update(instance);

    memset(&ipmi_ret, 0, sizeof(ipmi_ret));
    memset(&params, 0, sizeof(params));
    params.data.oem_pp_rpc_get_recep_state.receptacle = instance->instance_id - 1;
    // printf("outlet num %d\n", instance->instance_id - 1);
    ret = pp_ipmi_send_command(PP_IPMI_CMD_OEM_PP_RPC,
        PP_IPMI_OEM_PP_RPC_GET_RECEPTACLE_STATE,
        &params, &ipmi_ret, &err, NULL);
    if (ret) {
        printf("IPMI failure: %s.\n", pp_ipmi_get_error_string(err));
        return;
    }

    // set to property
    data.null = 0;
    // map value
    if ((ipmi_ret.data.oem_pp_rpc_get_recep_state_rs.status & 0x01) == 0)
        data.types.unsigned_int = 2;
    else
        data.types.unsigned_int = 1;
    pp_cim_set_property(instance, "powerState", data);

    pp_ipmi_cleanup_ret(&ipmi_ret);
}

void pp_cim_outlet_sensor_association(pp_cim_instance_t *outlet, vector_t *sensors)
{
    unsigned int i, j;
    pp_cim_instance_t *inst;
    pp_cim_propval_t *pv;
    //char outlet_id[10];
    unsigned char sensor_number;
    unsigned char outlet_number;
    //outlet_number = (((outlet->instance_id - 1) / 4) << 5) | 0x10 | (((outlet->instance_id - 1) % 4) << 2);
    outlet_number = ((outlet->instance_id - 1) << 3);
    //printf("outlet_number=%x\n", outlet_number);

    //printf("%s id %d outlet_number %x\n", __FUNCTION__, outlet->instance_id, outlet_number);

    for (i = 0; i < vector_size(sensors); i++) {
        inst = vector_get(sensors, i);
        pv = pp_cim_get_property(inst, "DeviceID");

        for (j = 0; j < strlen(pv->data.types.string); j++) {
            if (pv->data.types.string[j] == '.') {
                pv->data.types.string[j] = 0;
            }
        }
        sensor_number = (unsigned char)atoi(pv->data.types.string);
        //printf("%s: sensor_number %x\n", __FUNCTION__, sensor_number);

        //if ((sensor_number & 0xFC) == outlet_number) {
        if ((sensor_number & 0xf8) == outlet_number) {
            pp_cim_dependency_new("AssociatedSensor", inst, outlet);
        }
        pp_cim_propval_delete(pv);
    }
}

static pp_cim_method_call_t *outlet_map_set(pp_cim_instance_t *instance,
    pp_clp_property_value_t *prop)
{
    pp_cim_data_t *arg;
    pp_cim_methodptr_t *methodptr;
    pp_cim_method_call_t *call;

    if (strcasecmp(prop->property, "powerState") == 0) {
        char value[32];
        methodptr = provider_common_get_method(instance, "setPowerState");
        call = pp_cim_method_call_new(methodptr, instance);

        // sywang: text to number
        value[1] = 0;
        if (!strcmp(prop->value, "on") || !strcmp(prop->value, "ON"))
            value[0] = '1';
        else if (!strcmp(prop->value, "off") || !strcmp(prop->value, "OFF"))
            value[0] = '2';
        else if (!strcmp(prop->value, "cycle") || !strcmp(prop->value, "CYCLE"))
            value[0] = '3';
        else {
            unsigned int i;
            for (i = 0; i < strlen(prop->value); i++) {
                if (i == 32) {
                    value[31] = 0;
                    break;
                }
                if (isdigit(prop->value[i]))
                    value[i] = prop->value[i];
                else {
                    value[0] = '0';
                    value[1] = 0;
                    break;
                }
                value[i+1] = 0;
            }
        }
        arg = pp_cim_data_parse(call->methodptr->method->args[0].type, value); //prop->value);
        printf("%s: %d\n", __FUNCTION__, arg->types.unsigned_int);
        if (!arg)
            return NULL;
        vector_add(call->args, arg);
        return call;
    }

    return NULL;
}

static int outlet_setpowerstate(pp_cim_instance_t *instance, vector_t *args,
    pp_cim_data_t *result UNUSED)
{
    pp_cim_data_t *arg;
    int state;
    int err, ret;
    pp_ipmi_parameter_t params;
    //pp_ipmi_return_t ipmi_ret;

    if (vector_size(args) != 1)
        return PP_ERR;
    arg = vector_get(args, 0);
    state = arg->types.unsigned_int;

    memset(&params, 0, sizeof(params));
    params.data.oem_pp_rpc_set_recep_state.receptacle = instance->instance_id - 1;

    // value map again
    if (state == 1)
        params.data.oem_pp_rpc_set_recep_state.status = 1;
    else
        params.data.oem_pp_rpc_set_recep_state.status = 0;

    ret = pp_ipmi_send_command(PP_IPMI_CMD_OEM_PP_RPC,
        PP_IPMI_OEM_PP_RPC_SET_RECEPTACLE_STATE,
        &params, NULL, &err, NULL);
        //&params, &ipmi_ret, &err, NULL);
    if (ret) {
        printf("IPMI failure: %s.\n", pp_ipmi_get_error_string(err));
        return PP_ERR;
    }
    //pp_ipmi_cleanup_ret(&ipmi_ret);

    return PP_SUC;
}

