/*
 * PP_Outlet class implementation
 *
 * Note: For demonstration purposes only, this class is not covered
 *       by any spec.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <pp/cim.h>
#include <pp/cimTypes.h>
#include <pp/cim_provider.h>
//#include <pp/cfg.h>
#include <pp_gpio.h>
#include <pp/ipmi.h>
#include "cim_common.h"
#include "instance.h"
#include "provider_common.h"
#include "provider_port.h"
#include "wrapper_port.h"
#include "valmap_port.h"
#include "provider_dependency.h"
#include <pp/hal_common.h>
#include <pp/kvm.h>

// internal prototype
static void port_update(pp_cim_instance_t *instance);
static int port_authorize(pp_cim_instance_t *instance, const char *auth_string );


// provider API functions
static pp_cim_provider_t provider =
{
    .deinit = provider_common_deinit,
    .update = port_update,
    .commit = provider_common_commit,
    .authorize = port_authorize,
    .get_property = provider_common_get_property,
    .set_property = provider_common_set_property,
    .get_properties = provider_common_get_properties,
    .set_properties = provider_common_set_properties,
    .get_method = provider_common_get_method,
    .call_method = provider_common_call_method,
    .clp_map_reset = NULL, // 'reset' command not supported
    .clp_map_set = NULL,   // 'set' command not supported
    .clp_map_start = NULL, // 'start' command not supported
    .clp_map_stop = NULL   // 'stop' command not supported
};

// class properties
// { <name>, <type>, <array>,   <valmap>, <key>,      <priv>, <required>, <writable>, { <null>, { <defvalue> } } }
static pp_cim_property_t properties[] =
{
    {"Index",   PP_CIM_UNSIGNED,    0, port_index_valmap,   1, 0, 1, 1, {1, {0}}},
    {"type",    PP_CIM_UNSIGNED,    0, port_type_valmap,    1, 0, 1, 1, {1, {0}}},
    {"status",  PP_CIM_UNSIGNED,    0, port_status_valmap,  1, 0, 1, 1, {1, {0}}},
    {"Name",    PP_CIM_STRING,	    0, NULL,		    1, 0, 1, 1, {1, {0}}},
    {"portId",  PP_CIM_STRING,	    0, NULL,		    0, 0, 1, 0, {1, {0}}},
    {.name = NULL}
};

// class methods
// { <name>, <result>, <num_args>, <args>, <priv>, <defptr> }
static pp_cim_method_t methods[] =
{
    {.name = NULL}
};

// class description
pp_cim_class_desc_t pp_cim_port_desc =
{
    .cim_name = "CIM_Port",
    .dispname = "Port",
    .ufct = "port",
    .superclass = "CIM_ManagedElement",
    .assoc = 0,
    .properties = properties,
    .methods = methods,
    .update = NULL,
    .clp_update = NULL
};

// Create a new PP_Outlet instance
pp_cim_instance_t *pp_cim_port_new()
{
    pp_cim_instance_t *i = pp_cim_instance_new("CIM_Port", &provider);
    return i;
}

vector_t *pp_cim_ports()
{
    pp_cim_instance_t *inst;
    int port_count;
    int x; 
    char buf[20];

    pp_cim_data_t name, type, state, Index, port_id;

    name.null = 0;
    type.null = 0;
    state.null = 0;
    Index.null = 0;
    port_id.null = 0;

    port_count = pp_hal_common_get_target_port_cnt();
    vector_t *result = vector_new(NULL, port_count, NULL);

    for (x = 0; x < port_count; x++)
    {
	inst = pp_cim_port_new();

	sprintf (buf, "Port %d", x);
	name.types.string = strdup (buf);
	type.types.unsigned_int = 1;
	state.types.unsigned_int = 2;
	Index.types.unsigned_int = x;
	port_id.types.string_const = strdup ("testing");

	provider_common_set_property(inst, "Name", name, 1);
	provider_common_set_property(inst, "type", type, 1);
	provider_common_set_property(inst, "status", state, 1);
	provider_common_set_property(inst, "Index", Index, 1);
	provider_common_set_property(inst, "portId", port_id, 1);

	vector_add(result, inst);
    }

    return result;
}

// update the new port data
static void port_update(pp_cim_instance_t *instance)
{
    /* whatever is necessary to get actual values for our properties */
    pp_cim_propval_t *pv;
    port_details_t port;
    int port_index;
    int result;

    provider_common_update(instance);

    // Find the port index property for this instance
    pv =instance->provider->get_property(instance, "index");
    if (!pv || pv->data.null) {
        pp_cim_propval_delete(pv);
        return;
    }
    port_index = pv->data.types.unsigned_int;
    pp_cim_propval_delete(pv);
    
    // Find the port data from port manager for this port_index
    result = find_pm_port( port_index, &port );
    if (result == PP_ERR)
	return;

    // update the port type
    pv =instance->provider->get_property(instance, "type");
    if (!pv || pv->data.null) {
        pp_cim_propval_delete(pv);
        return;
    }
    pv->data.types.unsigned_int = port.type;
    provider_common_set_property(instance, "type", pv->data, 1);
    pp_cim_propval_delete(pv);

    // update the port status
    pv =instance->provider->get_property(instance, "status");
    if (!pv || pv->data.null) {
        pp_cim_propval_delete(pv);
        return;
    }
    pv->data.types.unsigned_int = port.status;
    provider_common_set_property(instance, "status", pv->data, 1);
    pp_cim_propval_delete(pv);

    // update the port id
    pv =instance->provider->get_property(instance, "portId");
    if (!pv || pv->data.null) {
        pp_cim_propval_delete(pv);
        return;
    }
    pv->data.types.string = strdup (port.port_id);
    provider_common_set_property(instance, "portId", pv->data, 1);
    pp_cim_propval_delete(pv);

    // update port name
    pv =instance->provider->get_property(instance, "Name");
    if (!pv || pv->data.null) {
        pp_cim_propval_delete(pv);
        return;
    }
    pv->data.types.string = strdup (port.port_name);
    provider_common_set_property(instance, "Name", pv->data, 1);
    pp_cim_propval_delete(pv);
}

// Authorize the wsman request
int port_authorize(pp_cim_instance_t *instance, const char *auth_string )
{
    int result;
    pp_cim_propval_t *pv;

    pv =instance->provider->get_property(instance, "Index");
    if (!pv || pv->data.null) {
        pp_cim_propval_delete(pv);
        return PP_ERR;
    }
    result = pp_kvm_is_port_allowed_for_user(auth_string,
				0, (int)pv->data.types.unsigned_int);
    return result;
}

