#include <pp/cim.h>
#include <pp/cimTypes.h>
#include <pp/cim_provider.h>
#include "cim_common.h"
#include "instance.h"
#include "provider_common.h"
#include "provider_powermanagementcapabilities.h"
#include "valmap_powermanagementcapabilities.h"

// class properties
// { <name>, <type>, <array>, <valmap>, <key>, <priv>, <required>, <writable>, { <null>, { <defvalue> } } }
static pp_cim_property_t properties[] =
{
    {"PowerCapabilities", PP_CIM_UNSIGNED, 1, powercapabilities_valmap, 0, 0, 1, 0, {1, {0}}},
    {"OtherPowerCapabilitiesDescriptions", PP_CIM_STRING_CONST, 1, NULL, 0, 0, 0, 0, {1, {0}}},
    {.name = NULL}
};

// class description
pp_cim_class_desc_t pp_cim_powermanagementcapabilities_desc =
{
    .cim_name = "CIM_PowerManagementCapabilities",
    .ufct = "pwrmgtcap",
    .dispname = "CIM Power Management Capabilities",
    .superclass = "CIM_Capabilities",
    .assoc = 0,
    .properties = properties,
    .methods = NULL, // no methods
    .update = NULL,
    .clp_update = NULL
};

// Create a new CIM_PowerManagementCapabilities instance
pp_cim_instance_t *pp_cim_powermanagementcapabilities_new()
{
    pp_cim_instance_t *i = pp_cim_instance_new("CIM_PowerManagementCapabilities", &provider_common);
    pp_cim_data_t d1;
    pp_cim_data_t *d2;
    d1.null = 0;
    d1.types.string_const = "IPMI: Power Management Capabilities";
    provider_common_set_property(i, "InstanceID", d1, 1);
    d1.types.array = vector_new(NULL, 1, NULL);
    d2 = malloc(sizeof(pp_cim_data_t));
    d2->null = 0;
    d2->types.unsigned_int = 3;
    vector_add(d1.types.array, d2);
    provider_common_set_property(i, "PowerCapabilities", d1, 1);
    free(d2);
    vector_delete(d1.types.array);
    return i;
}

