#include <pp/cim.h>
#include <pp/cimTypes.h>
#include <pp/cim_provider.h>
#include "cim_common.h"
#include "instance.h"
#include "provider_privilege.h"
#include "valmap_privilege.h"

// class properties
// { <name>, <type>, <array>, <valmap>, <key>, <priv>, <required>, <writable>, { <null>, { <defvalue> } } }
static pp_cim_property_t properties[] =
{
    {"InstanceID", PP_CIM_STRING_CONST, 0, NULL, 1, 0, 1, 0, {1, {0}}},
    {"PrivilegeGranted", PP_CIM_BOOLEAN, 0, NULL, 0, 0, 1, 0, {0, {.boolean = 1}}},
    {"Activities", PP_CIM_UNSIGNED, 1, activities_valmap, 0, 0, 1, 0, {1, {0}}},
    {.name = NULL}
};

// class description
pp_cim_class_desc_t pp_cim_privilege_desc =
{
    .cim_name = "CIM_Privilege",
    .ufct = NULL,
    .dispname = "CIM Privilege",
    .superclass = "CIM_ManagedElement",
    .assoc = 0,
    .properties = properties,
    .methods = NULL, // no methods
    .update = NULL,
    .clp_update = NULL
};

