#include <pp/cim.h>
#include <pp/cimTypes.h>
#include <pp/cim_provider.h>
#include "cim_common.h"
#include "instance.h"
#include "provider_common.h"
#include "provider_recordinlog.h"

// class properties
// { <name>, <type>, <array>, <valmap>, <key>, <priv>, <required>, <writable>, { <null>, { <defvalue> } } }
static pp_cim_property_t properties[] =
{
    {"MessageLog", PP_CIM_REFERENCE, 0, NULL, 1, 0, 1, 0, {1, {0}}},
    {"LogRecord", PP_CIM_REFERENCE, 0, NULL, 1, 0, 1, 0, {1, {0}}},
    {.name = NULL}
};

// class description
pp_cim_class_desc_t pp_cim_recordinlog_desc =
{
    .cim_name = "CIM_RecordInLog",
    .ufct = NULL,
    .dispname = "CIM Record In Log",
    .superclass = NULL,
    .assoc = 1,
    .properties = properties,
    .methods = NULL, // no methods
    .update = NULL,
    .clp_update = NULL
};

// Create a new CIM_RecordInLog instance
pp_cim_instance_t *pp_cim_recordinlog_new(
    pp_cim_instance_t *log_inst, pp_cim_instance_t *record)
{
    pp_cim_data_t d;
    pp_cim_instance_t *i = pp_cim_instance_new("CIM_RecordInLog", &provider_common);
    d.null = log_inst ? 0 : 1;
    d.types.reference = log_inst;
    provider_common_set_property(i, "MessageLog", d, 1);
    d.null = record ? 0 : 1;
    d.types.reference = record;
    provider_common_set_property(i, "LogRecord", d, 1);
    return i;
}

