#include <pp/cim.h>
#include <pp/cimTypes.h>
#include <pp/cim_provider.h>
#include "cim_common.h"
#include "instance.h"
#include "provider_service.h"

// class properties
// { <name>, <type>, <array>, <valmap>, <key>, <priv>, <required>, <writable>, { <null>, { <defvalue> } } }
static pp_cim_property_t properties[] =
{
    {"SystemCreationClassName", PP_CIM_STRING_CONST, 0, NULL, 1, 0, 1, 0, {0, {.string_const = "CIM_ComputerSystem"}}},
    {"SystemName", PP_CIM_STRING_CONST, 0, NULL, 1, 0, 1, 0, {0, {.string_const = "Management"}}},
    {"CreationClassName", PP_CIM_STRING_CONST, 0, NULL, 1, 0, 1, 0, {1, {0}}},
    {"Name", PP_CIM_STRING_CONST, 0, NULL, 1, 0, 1, 0, {1, {0}}},
    {"PrimaryOwnerName", PP_CIM_STRING_CONST, 0, NULL, 0, 0, 0, 0, {1, {0}}},
    {"PrimaryOwnerContact", PP_CIM_STRING_CONST, 0, NULL, 0, 0, 0, 0, {1, {0}}},
    {"Started", PP_CIM_BOOLEAN, 0, NULL, 0, 0, 0, 0, {1, {0}}},
    {.name = NULL}
};

// class methods
// { <name>, <result>, <num_args>, <args>, <priv>, <defptr> }
static pp_cim_method_t methods[] =
{
    {"StartService", PP_CIM_UNSIGNED, 0, NULL, 0, NULL},
    {"StopService", PP_CIM_UNSIGNED, 0, NULL, 0, NULL},
    {.name = NULL}
};

// class description
pp_cim_class_desc_t pp_cim_service_desc =
{
    .cim_name = "CIM_Service",
    .ufct = "service",
    .dispname = "CIM Service",
    .superclass = "CIM_EnabledLogicalElement",
    .assoc = 0,
    .properties = properties,
    .methods = methods,
    .update = NULL,
    .clp_update = NULL
};

