#include "disconf_intern.h"
#ifdef WIN32
#include <winsock2.h>
#endif

int
write_bn(BIO *bio,BIGNUM *bn)
{
    u_int16_t size=BN_num_bytes(bn);
    char *temp=(char*)malloc(size);
    int ret;
    BN_bn2bin(bn,(u_int8_t*)temp);
    ret=write_uint16(bio,size)&&write_data(bio,temp,size);
    free(temp);
    return ret;
}

int
read_bn(BIO *bio,BIGNUM **bn)
{
    u_int16_t size;
    char* data;

    if(!read_uint16(bio,&size))
	return 0;

    if(!read_data(bio,&data,size))
	return 0;
    *bn=BN_bin2bn((u_int8_t*)data,size,NULL);
	free(data);
    return 1;
}

int
read_uint8(BIO* bio,u_int8_t *ret)
{
    if(BIO_read(bio,ret,1))
	return 1;
    return 0;
}

int
read_uint16(BIO* bio,u_int16_t *ret)
{
    if(BIO_read(bio,ret,2)) {
	*ret=ntohs(*ret);
	return 1;
    }
    return 0;
}

int
read_uint32(BIO* bio,u_int32_t *ret)
{
    if(BIO_read(bio,ret,4)) {
	*ret=ntohl(*ret);
	return 1;
    }
    return 0;
}

int
read_uint64(BIO* bio,u_int64_t *ret)
{
    if(BIO_read(bio,ret,8)) {
	// TODO: ntohll
	return 1;
    }
    return 0;
}

int
read_data(BIO* bio,char** data,size_t size)
{
    *data=NULL;
    if((*data=(char*)malloc(size))&&
       BIO_read(bio,*data,size))
	return 1;
    if(*data)
	free(data);
    return 0;
}

int
write_uint8(BIO* bio,u_int8_t ret)
{
    if(BIO_write(bio,&ret,1))
	return 1;
    return 0;
}

int
write_uint16(BIO* bio,u_int16_t ret)
{
    ret=htons(ret);
    if(BIO_write(bio,&ret,2)) {
	return 1;
    }
    return 0;
}

int
write_uint32(BIO* bio,u_int32_t ret)
{
    ret=htonl(ret);
    if(BIO_write(bio,&ret,4)) {
	return 1;
    }
    return 0;
}

int
write_uint64(BIO* bio,u_int64_t ret)
{
    u_int32_t a=ret>>32,b=ret&0x00000000ffffffff;
    if(write_uint32(bio,a)&&write_uint32(bio,b)) {
	return 1;
    }
    return 0;
}

int
write_data(BIO* bio,char* data,size_t size)
{
    return BIO_write(bio,data,size);
}

int
write_node(BIO *bio,u_int8_t tag,char* data,u_int16_t size)
{
    return write_uint8(bio,tag)&&write_uint16(bio,size)&&write_data(bio,data,size);
}
