#include "disconf_intern.h"
#include <pp/disconf.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <openssl/rand.h>
#include <openssl/bio.h>
#include <openssl/evp.h>

static int pp_dc_init_socket(int * sock)
{
    struct sockaddr_in sa={AF_INET,htons(27182),{htonl(INADDR_ANY)},{}};
    if((*sock=socket(PF_INET,SOCK_DGRAM,0))==-1)
	return PP_ERR;
    
    if(bind(*sock,&sa,sizeof(sa))==-1)
	return PP_ERR;

    {
	int i=1;
	setsockopt(*sock,SOL_SOCKET,SO_BROADCAST,(const char*)&i,sizeof(i));
    }
    
    return PP_SUC;
}

int pp_dc_generate_msgid(u_int32_t * msgid)
{
    *msgid=0;
    if(RAND_bytes((unsigned char*)msgid,sizeof(*msgid))!=1)
	return -1;
    else
	return 0;
}

int pp_dc_get_pubkey(char * data,size_t size,pp_dc_pubkey_t ** pubkey)
{
    pp_dc_cnode_t * node=NULL;
    BIO * bio;

    if(size==0)
    {
	*pubkey=NULL;
	return PP_ERR;
    }

    bio=BIO_new_mem_buf(data,size);
    bio=BIO_push(BIO_new(BIO_f_base64()),bio);
    BIO_set_flags(bio,BIO_FLAGS_BASE64_NO_NL);
    if(pp_dc_cnode_parse(bio,&node) && node)
    {
	*pubkey=pp_dc_cnode2pubkey(node);
	free(node);
    }
    BIO_free_all(bio);
    return PP_SUC;
}

#define MTU 2000
static int pp_dc_recvfrom(int sock,pp_eui64_t from_eui64,pp_eui64_t to_eui64,u_int32_t msgid,pp_dc_pubkey_t * pubkey,struct in_addr * from_addr,pp_dc_command_t * response,char ** data,size_t * len,int * response_enc)
{
    pp_dc_net_t * net=alloca(MTU);
    struct sockaddr_in from;
    socklen_t fromlen=sizeof(from);
    ssize_t size;
    int ret=PP_ERR;
    pp_dc_cnode_t * cnode=NULL;
    pp_dc_message_t * msg=NULL;
    int msg_size;

    if((size=recvfrom(sock,net,MTU,0,&from,&fromlen))==-1)
	goto bail;

    if((size_t)size<sizeof(pp_dc_net_t)+3+sizeof(pp_dc_message_t))
	goto bail;
    
    net->magic_num=ntohl(net->magic_num);
    if(net->magic_num!=PP_DC_MAGIC_NUM)
	goto bail;

    if(memcmp(net->dest.ui,to_eui64.ui,sizeof(pp_eui64_t))!=0 &&
	    memcmp(net->dest.ui,eui64_all.ui,sizeof(pp_eui64_t))!=0)
	goto bail;
    
    if(memcmp(net->src.ui,from_eui64.ui,sizeof(pp_eui64_t))!=0)
	goto bail;

    if(!pp_dc_cnode_parse_mem(net->data,size-sizeof(pp_dc_net_t),&cnode))
	goto bail;
    
    if((msg_size=pp_dc_decrypt_and_verify(cnode,response_enc,ks_privkey,pubkey,(char**)msg))<=0)
	goto bail;

    if(msg->msg_id!=msgid)
	goto bail;

    if(from_addr)
	*from_addr=from.sin_addr;
    if(response)
	*response=msg->command;
    if(len && data) {
	*len=msg_size-sizeof(pp_dc_message_t);
	*data=malloc(*len);
	memcpy(*data,msg->data,*len);
    }

    ret=PP_SUC;
    
bail:
    if(cnode)
	pp_dc_cnode_free(cnode);

    return ret;

}

int pp_dc_sendto(int sock,pp_eui64_t from_eui64,pp_eui64_t to_eui64,struct in_addr to_addr,pp_dc_command_t command,u_int32_t msgid,char * data,size_t len,int send_enc,pp_dc_pubkey_t * pubkey)
{
    pp_dc_cnode_t *node;
    pp_dc_message_t *msg=HEADER_MALLOC(pp_dc_message_t,len);
    BIO *bio;
    char * temp_data;
    size_t temp_size;
    pp_dc_net_t *net;

    msg->command=command;
    msg->msg_id=msgid;

    if(len)
	memcpy(msg->data,data,len);

    pp_dc_sign_and_encrypt((char*)msg,sizeof(pp_dc_message_t)+len,send_enc,ks_privkey,pubkey,&node);

    bio=BIO_new(BIO_s_mem());

    pp_dc_cnode_build(bio,node);

    temp_size=BIO_get_mem_data(bio,&temp_data);

    net=HEADER_MALLOC(pp_dc_net_t,temp_size);
    net->dest=to_eui64;
    net->src=from_eui64;
    net->magic_num=htonl(PP_DC_MAGIC_NUM);
    net->version=PP_DC_VERSION;
    memcpy(net->data,temp_data,temp_size);

    temp_size+=sizeof(pp_dc_net_t);

    BIO_free(bio);
    pp_dc_cnode_free(node);

    struct sockaddr_in addr;
    addr.sin_addr=to_addr;
    addr.sin_port=htons(456);
    addr.sin_family=AF_INET;

    int ret=sendto(sock,net,temp_size,0,&addr,sizeof(addr));

    if(ret==-1)
	perror("sento ");

    free(net);
    free(msg);

    return ret;
}

int pp_dc_send_ping(int sock,pp_eui64_t from_eui64,pp_eui64_t to_eui64,struct in_addr to_addr,u_int32_t msgid)
{
    return pp_dc_sendto(sock,from_eui64,to_eui64,to_addr,PP_DC_COMMAND_PING,msgid,NULL,0,0,NULL);
}

int pp_dc_send_get_pubkey(int sock,pp_eui64_t from_eui64,pp_eui64_t to_eui64,struct in_addr to_addr,u_int32_t msgid)
{
    return pp_dc_sendto(sock,from_eui64,to_eui64,to_addr,PP_DC_COMMAND_GET_PUBKEY,msgid,NULL,0,0,NULL);
}

int pp_dc_send_bind(int sock,pp_eui64_t from_eui64,pp_eui64_t to_eui64,struct in_addr to_addr,u_int32_t msgid,pp_dc_pubkey_t * pubkey)
{
    pp_dc_cnode_t *node=pp_dc_pubkey2cnode(ks_pubkey);
    BIO *bio=BIO_new(BIO_s_mem());
    char *data;
    size_t size;

    pp_dc_cnode_build(bio,node);
    free(node);
    size=BIO_get_mem_data(bio,&data);
    int ret=pp_dc_sendto(sock,from_eui64,to_eui64,to_addr,PP_DC_COMMAND_BIND,msgid,data,size,PP_DC_SIGNED|PP_DC_ENCRYPTED,pubkey);
    BIO_free(bio);

    return ret;
}

int pp_dc_send_ccf_delete(int sock,pp_eui64_t from_eui64,pp_eui64_t to_eui64,struct in_addr to_addr,u_int32_t msgid,pp_dc_pubkey_t * pubkey)
{
    return pp_dc_sendto(sock,from_eui64,to_eui64,to_addr,PP_DC_COMMAND_CCF_CREATE,msgid,NULL,0,PP_DC_SIGNED|PP_DC_ENCRYPTED,pubkey);
}

int pp_dc_send_ccf_create(int sock,pp_eui64_t from_eui64,pp_eui64_t to_eui64,struct in_addr to_addr,u_int32_t msgid,char * passwd,pp_dc_pubkey_t * pubkey)
{
    return pp_dc_sendto(sock,from_eui64,to_eui64,to_addr,PP_DC_COMMAND_CCF_CREATE,msgid,passwd,strlen(passwd),PP_DC_SIGNED|PP_DC_ENCRYPTED,pubkey);
}

int pp_dc_send_recv_ccf_create(pp_eui64_t to_eui64,struct in_addr to_addr,char * passwd,pp_dc_pubkey_t * pubkey,long timeout,char ** user)
{
    int sock;
    pp_eui64_t my_eui64;
    u_int32_t msgid;
    fd_set rfds;
    int ret=PP_ERR;
    struct timeval tv={0,timeout};
    pp_dc_command_t response;
    int response_enc;
    size_t len;

    FD_ZERO(&rfds);
    if(pp_dc_init_socket(&sock)==PP_ERR)
	goto bail;
    FD_SET(sock,&rfds);
    if(pp_dc_generate_msgid(&msgid)==PP_ERR)
	goto bail;
    if(RAND_bytes((unsigned char*)&my_eui64,sizeof(my_eui64))==0)
	goto bail;
    if(pp_dc_send_ccf_create(sock,my_eui64,to_eui64,to_addr,msgid,passwd,pubkey)==PP_ERR)
	goto bail;

    if(select(sock+1,&rfds,NULL,NULL,&tv)<0)
	goto bail;
	
    if(pp_dc_recvfrom(sock,my_eui64,to_eui64,msgid,pubkey,NULL,&response,user,&len,&response_enc)==PP_ERR)
	goto bail;

    if(response!=PP_DC_RESPONSE_OK)
	goto bail;

    ret=PP_SUC;
    
bail:
    if(sock>=0)
	close(sock);

    return ret;
}

int pp_dc_send_recv_ccf_delete(pp_eui64_t to_eui64,struct in_addr to_addr,pp_dc_pubkey_t * pubkey,long timeout)
{
    int sock;
    pp_eui64_t my_eui64;
    u_int32_t msgid;
    fd_set rfds;
    int ret=PP_ERR;
    struct timeval tv={0,timeout};
    pp_dc_command_t response;
    int response_enc;

    FD_ZERO(&rfds);
    if(pp_dc_init_socket(&sock)==PP_ERR)
	goto bail;
    FD_SET(sock,&rfds);
    if(pp_dc_generate_msgid(&msgid)==PP_ERR)
	goto bail;
    if(RAND_bytes((unsigned char*)&my_eui64,sizeof(my_eui64))==0)
	goto bail;
    if(pp_dc_send_ccf_delete(sock,my_eui64,to_eui64,to_addr,msgid,pubkey)==PP_ERR)
	goto bail;

    if(select(sock+1,&rfds,NULL,NULL,&tv)<0)
	goto bail;
	
    if(pp_dc_recvfrom(sock,my_eui64,to_eui64,msgid,pubkey,NULL,&response,NULL,NULL,&response_enc)==PP_ERR)
	goto bail;

    if(response!=PP_DC_RESPONSE_OK)
	goto bail;

    ret=PP_SUC;
    
bail:
    if(sock>=0)
	close(sock);

    return ret;
}
