#include "crypto.h"
#include "disconf_intern.h"

#include <openssl/bio.h>
#include <openssl/evp.h>

pp_dc_privkey_t *ks_privkey;
pp_dc_pubkey_t *ks_pubkey,*ks_pubkey_pemx;

static int generate_keystore(void);

#ifdef WIN32

# include <windows.h>
# define PP_REGKEY "Software\\Peppercon AG\\PEMiX\\Discovery"

static int
write_keystore(void)
{
    int ret;
    HKEY key;
    BIO *bio;
    char *data;
    LONG size;
    pp_dc_cnode_t *node;
    
    
    RegCreateKeyEx(HKEY_CURRENT_USER,
		   PP_REGKEY,
		   0,
		   NULL,
		   0,
		   KEY_ALL_ACCESS,
		   NULL,
		   &key,
		   NULL);
    
    bio=BIO_new(BIO_s_mem());
    
    node=pp_dc_privkey2cnode(ks_privkey);
    pp_dc_cnode_build(bio,node);
    free(node);
    
    size=BIO_get_mem_data(bio,&data);
    
    RegSetValueEx(key,"privkey",0,REG_BINARY,data,size);
    BIO_free(bio);
    
}

static int
read_keystore(void)
{
    char buf[1024];
    LONG size=1024;
    int ret;
    HKEY key;

    RegCreateKeyEx(HKEY_CURRENT_USER,
		   PP_REGKEY,
		   0,
		   NULL,
		   0,
		   KEY_ALL_ACCESS,
		   NULL,
		   &key,
		   NULL);

    if(RegQueryValueEx(key,"privkey",NULL,NULL,buf,&size)==ERROR_SUCCESS)
	{
	    pp_dc_cnode_t *node;
	    ret=pp_dc_cnode_parse_mem(buf,size,&node);
	    ks_privkey=pp_dc_cnode2privkey(node);
	    ks_pubkey=pp_dc_privkey2pubkey(ks_privkey);
	    free(node);
	}
    else
	generate_keystore();
    
}


#else /* !WIN32 */

# if !defined(PRODUCT_CCF)
#  include <pp/cfg.h>

static int
write_keystore(void)
{
    BIO *b64,*mem;
    pp_dc_cnode_t *node;
    char *data;
    
    node=pp_dc_privkey2cnode(ks_privkey);
    if(ks_pubkey_pemx)
	node->next=pp_dc_pubkey2cnode(ks_pubkey_pemx);    
    mem=BIO_new(BIO_s_mem());
    b64=BIO_new(BIO_f_base64());
    BIO_set_flags(b64,BIO_FLAGS_BASE64_NO_NL);
    BIO_push(b64,mem);
    pp_dc_cnode_build(b64,node);
    BIO_flush(b64);
    BIO_write(mem,"",1);
    if(ks_pubkey_pemx)
	free(node->next);
    free(node);
    BIO_get_mem_data(mem,&data);

    if(pp_cfg_set(data,"config_protocol.private_key")==PP_ERR)
	printf("could not write privkey\n");
    if(pp_cfg_save(DO_FLUSH)==PP_ERR)
	printf("couldn't save\n");
    BIO_free_all(b64);
    return 1;
}

static int
read_keystore(void)
{
    BIO *bio;
    int ret;
    pp_dc_cnode_t *node;
    char *data;

    if(pp_cfg_get_nodflt(&data,"config_protocol.private_key")==PP_ERR) {
	return generate_keystore();
    }
    else {
	bio=BIO_new_mem_buf(data,strlen(data));
	bio=BIO_push(BIO_new(BIO_f_base64()),bio);
	BIO_set_flags(bio,BIO_FLAGS_BASE64_NO_NL);
	ret=pp_dc_cnode_parse(bio,&node);
	ks_privkey=pp_dc_cnode2privkey(node);
	ks_pubkey=pp_dc_privkey2pubkey(ks_privkey);
	if(node->next) {
	    ks_pubkey_pemx=pp_dc_cnode2pubkey(node->next);
#if 0
	    printf("pemx-pubkey present\n");
#endif
	}
	free(node->next);
	free(node);
	BIO_free_all(bio);
	free(data);

	return ret;
    }
}
# else /* PRODUCT_CCF */


static int
write_keystore(void)
{
    BIO *bio;
    pp_dc_cnode_t *node;
    
    node=pp_dc_privkey2cnode(ks_privkey);
    if(ks_pubkey_pemx)
	node->next=pp_dc_pubkey2cnode(ks_pubkey_pemx);
    char *home=getenv("HOME");
    char file[]="/.Discovery";
    char s[strlen(home)+sizeof(file)];
    s[0]=0;
    strcat(s,home);
    strcat(s,file);
    printf(" keyfile: %s\n",s);
    bio=BIO_new_file(s,"w");
    pp_dc_cnode_build(bio,node);
    BIO_flush(bio);
    if(ks_pubkey_pemx)
	free(node->next);
    free(node);

    BIO_free_all(bio);
    return 1;
}

static int
read_keystore(void)
{
    BIO *bio;
    int ret;
    pp_dc_cnode_t *node;
    char *home=getenv("HOME");
    char file[]="/.Discovery";
    char s[strlen(home)+sizeof(file)];
    s[0]=0;
    strcat(s,home);
    strcat(s,file);
    printf(" keyfile: %s\n",s);

    if(!(bio=BIO_new_file(s,"r"))) {
	return generate_keystore();
    }
    else {
	ret=pp_dc_cnode_parse(bio,&node);
	ks_privkey=pp_dc_cnode2privkey(node);
	ks_pubkey=pp_dc_privkey2pubkey(ks_privkey);
	if(node->next) {
	    ks_pubkey_pemx=pp_dc_cnode2pubkey(node->next);
#if 0
	    printf("pemx-pubkey present\n");
#endif
	}
	free(node->next);
	free(node);
	BIO_free_all(bio);

	return ret;
    }
}

# endif /* PRODUCT_CCF */

#endif /* !WIN32 */

static int
generate_keystore(void)
{
    printf("generating RSA-key...");
    ks_privkey=pp_dc_privkey_gen();
    ks_pubkey=pp_dc_privkey2pubkey(ks_privkey);
    ks_pubkey_pemx=NULL;
    printf("done\n");
    write_keystore();
    return 1;
}


int
pp_dc_keystore_init(void)
{
    ks_pubkey_pemx = NULL;
    return read_keystore();
}


int
pp_dc_keystore_set_pemx(pp_dc_pubkey_t *pemx)
{
    if(!pemx) pp_dc_pubkey_free(ks_pubkey_pemx);
    ks_pubkey_pemx = pemx;
    return write_keystore();
}
