#include "crypto.h"
#include "disconf_intern.h"

/***************************************************************
 * Plain
 ***************************************************************/

pp_dc_plain_t*
pp_dc_plain_new()
{
    pp_dc_plain_t *ret=(pp_dc_plain_t*)malloc(sizeof(pp_dc_plain_t));

    ret->size=0;
    ret->data=NULL;
    return ret;
}

pp_dc_cnode_t*
pp_dc_plain2cnode(pp_dc_plain_t *x)
{
    return pp_dc_cnode_create(PP_DC_TAG_PLAIN,x);
}

pp_dc_plain_t*
pp_dc_cnode2plain(pp_dc_cnode_t *x)
{
    if(x->tag==PP_DC_TAG_PLAIN)
	return x->un.plain;
    else
	return NULL;
}

int
pp_dc_plain_parse(BIO* bio,pp_dc_plain_t **plain,size_t size)
{
    *plain=pp_dc_plain_new();
    (*plain)->size=size;
    return read_data(bio,(char**)&(*plain)->data,size);
}

int
pp_dc_plain_build(BIO *bio,pp_dc_plain_t *plain)
{
    return write_data(bio,(char*)plain->data,plain->size);
}

void
pp_dc_plain_free(pp_dc_plain_t *plain)
{
    free(plain->data);
    free(plain);
}

pp_dc_plain_t*
pp_dc_plain_gen(char* data,size_t size)
{
    pp_dc_plain_t *ret=pp_dc_plain_new();
    ret->data=(u_int8_t*)malloc(size);
    memcpy(ret->data,data,size);
    ret->size=size;
    return ret;
}
