#include "disconf_intern.h"

#include <openssl/evp.h>
#include <openssl/sha.h>
#include <pp/bio.h>

/***************************************************************
 * Pubkey
 ***************************************************************/

pp_dc_pubkey_t*
pp_dc_pubkey_new()
{
    pp_dc_pubkey_t *ret=(pp_dc_pubkey_t*)malloc(sizeof(pp_dc_pubkey_t));

    ret->algo=0;
    ret->key.gen=NULL;

    return ret;
}

pp_dc_cnode_t*
pp_dc_pubkey2cnode(pp_dc_pubkey_t *x)
{
    return pp_dc_cnode_create(PP_DC_TAG_PUBKEY,x);
}

pp_dc_pubkey_t*
pp_dc_cnode2pubkey(pp_dc_cnode_t *x)
{
    if(x->tag==PP_DC_TAG_PUBKEY)
	return x->un.pubkey;
    else
	return NULL;
}

int
pp_dc_pubkey_parse(BIO *bio,pp_dc_pubkey_t **pubkey,size_t size)
{
    char *data;
    BIO *membio;

    *pubkey=pp_dc_pubkey_new();
    if(!(read_uint8(bio,&pubkey[0]->algo)&&
	 read_uint64(bio,(u_int64_t*)&pubkey[0]->keyid)&&
	 read_data(bio,&data,size-9))) {
	return 0;
    }

    membio=BIO_new_mem_buf(data,size-9);

    switch((*pubkey)->algo) {
    case PP_DC_PUB_RSA:
	(*pubkey)->key.rsa=RSA_new();
	if(!(read_bn(membio,&(*pubkey)->key.rsa->n) &&
	     read_bn(membio,&(*pubkey)->key.rsa->e))) {
	    RSA_free(pubkey[0]->key.rsa);
	    free(pubkey[0]);
	    BIO_free(membio);
		if(data) free(data);
	    return 0;
	}
	break;
    }

    BIO_free(membio);
	if(data) free(data);

    return 1;
}

int
pp_dc_pubkey_build(BIO *bio,pp_dc_pubkey_t *pubkey)
{
    if(!(write_uint8(bio,pubkey->algo)&&
	 write_data(bio,(char*)&pubkey->keyid,8)))
	return 0;

    switch(pubkey->algo){
    case PP_DC_PUB_RSA:
	if(!(write_bn(bio,pubkey->key.rsa->n)&&
	     write_bn(bio,pubkey->key.rsa->e)))
	    return 0;
	break;
    }
    return 1;
}

void
pp_dc_pubkey_free(pp_dc_pubkey_t *pubkey)
{
    switch(pubkey->algo) {
    case PP_DC_PUB_RSA:
	RSA_free(pubkey->key.rsa);
	break;
    }
    free(pubkey);
}

static pp_dc_keyid_t
md2keyid(char *md)
{
    pp_dc_keyid_t ret;
    memcpy(&ret,md,8);
    return ret;
}

pp_dc_keyid_t
pp_dc_pubkey_keyid(pp_dc_pubkey_t *pubkey)
{
    BIO *bio = BIO_new(BIO_s_null());
    char md[SHA_DIGEST_LENGTH];

    bio = BIO_push(BIO_new(BIO_f_md()),bio);
    pp_bio_set_md(bio, EVP_sha1());

    switch(pubkey->algo) {
    case PP_DC_PUB_RSA: 
	{
	    write_bn(bio,pubkey->key.rsa->n);
	    write_bn(bio,pubkey->key.rsa->e);
	}
	break;
    }

    BIO_gets(bio,md,SHA_DIGEST_LENGTH);
    BIO_free_all(bio);
    return md2keyid(md);
}

int
pp_dc_pubkey_encrypt(char *indata,size_t insize,pp_dc_pubkey_t *pubkey,char **outdata,size_t *outsize)
{
    switch(pubkey->algo){
    case PP_DC_PUB_RSA:
	*outdata=malloc(RSA_size(pubkey->key.rsa));
	*outsize=RSA_public_encrypt(insize,(unsigned char*)indata,(unsigned char*)*outdata,pubkey->key.rsa,RSA_PKCS1_PADDING);
	return 1;
	break;
    default:
	return 0;
    }
}

int
pp_dc_pubkey_decrypt(char *indata,size_t insize,pp_dc_pubkey_t *pubkey,char **outdata,size_t *outsize)
{
    switch(pubkey->algo){
    case PP_DC_PUB_RSA:
	*outdata=malloc(RSA_size(pubkey->key.rsa));
	*outsize=RSA_public_decrypt(insize,(unsigned char*)indata,(unsigned char*)*outdata,pubkey->key.rsa,RSA_PKCS1_PADDING);
	return 1;
	break;
    default:
	return 0;
    }
}
