#ifndef _DIRECT_H
#define _DIRECT_H

#include "common.h"

pp_grab_client_t* new_client_direct(pp_grab_mem_desc_id_t id, u_char video_link);
void remove_client_direct(pp_grab_client_t *client);
int request_region_direct(pp_grab_client_t *client, pp_grab_req_flags_t flags,
			  RegionRec *req, RegionRec *ack, RegionRec *remain);
int request_rect_direct(pp_grab_client_t *client, pp_grab_req_flags_t flags,
			u_short x, u_short y, u_short w, u_short h);

void transfer_direct(RegionRec *diff_reg, u_char refresh_pending, u_char video_link);
void cancel_requests_direct(u_char reason, u_char video_link);

int request_screen_sync_direct(pp_grab_client_t *client, u_char hw_downscale, u_char *scale);
int release_screen_sync_direct(pp_grab_client_t *client);

void sync_fb_direct(pp_grab_sync_lock_t action, u_char video_link);

extern grab_driver_t grab_driver_direct;
extern pthread_mutex_t fb_sync_mtx;

#endif /* _DIRECT_H */
