#ifndef _MEMPOOL_H
#define _MEMPOOL_H

#include <pp/base.h>
#include "pp/grab.h"

/*********************************************************************
 * liberic_grab: mempool.h
 *
 * Partition the physically continous memory provided by the kernel
 * for various clients
 ********************************************************************/

typedef struct {
    struct list_head listnode;	/* list handle */
    
    pp_grab_mem_desc_id_t id; /* id, if fix memory descriptor, 0 otherwise */
    u_char    in_use;	   /* true if fix desc and in use, 0 otherwise */
    
    u_char   *ptr;	   /* user space pointer */
    u_int32_t offset;	   /* offset into the memory pool */
    u_int32_t size;	   /* size of this memory block */
    u_char    video_link;  /* frame grabber */
} mem_desc_t;

extern u_char *mem_pool;

int mempool_init(void);
void mempool_cleanup(void);

int mempool_reserve_fix_desc(pp_grab_mem_desc_id_t id, u_int32_t size, u_char video_link);
void mempool_start_var_alloc(void);

mem_desc_t *mempool_get_desc(u_char id, u_char video_link);
void mempool_release_desc(mem_desc_t *desc);

#endif /* _MEMPOOL_H */
