#include <mtd/mtd-user.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <pp/hal_common.h>
#include <pp/features.h>
#include "flashid.h"

#define FLASH_DEVICE "/dev/mtd0"

static char * get_flash_id(int type);

char *
get_flash_factory_id(void)
{
    return get_flash_id(MTD_OTP_FACTORY);
}

char *
get_flash_user_id(void)
{
    return get_flash_id(MTD_OTP_USER);
}

char *
get_flash_user_id_lock(void)
{
    struct otp_info info;
    char * ret = NULL;
    int fd, type, otp_region_cnt;

    fd = open(FLASH_DEVICE, O_RDONLY);
    if (fd < 0) goto bail;
    type = MTD_OTP_USER;
    if (ioctl(fd, OTPSELECT, &type) < 0) goto bail;
    if (ioctl(fd, OTPGETREGIONCOUNT, &otp_region_cnt) < 0) goto bail;
    if (otp_region_cnt == 1) {
	if (ioctl(fd, OTPGETREGIONINFO, &info) < 0) goto bail;
	ret = strdup(info.locked ? "1" : "0");
    }

 bail:
    if (fd != -1) close(fd);
    return ret;
}

#ifdef PP_FEAT_CREATE_FLASHID

int
set_flash_user_id(const char * id)
{
    char rawbuf[PP_HAL_COMMON_MAX_FLASHID_LEN / 2];
    int fd, type, i, n, ret = PP_ERR;

    fd = open(FLASH_DEVICE, O_RDONLY);
    if (fd < 0) goto bail;
    type = MTD_OTP_USER;
    if (ioctl(fd, OTPSELECT, &type) < 0) goto bail;
    n = strlen(id) / 2;
    for (i = 0; i < n; ++i) {
	sscanf(&id[i*2], "%02hhx", &rawbuf[i]);
    }
    if (write(fd, rawbuf, n) != n) goto bail;
    ret = PP_SUC;
    
 bail:
    if (fd != -1) close(fd);
    return ret;  
}

int
set_flash_user_id_lock(void)
{
    struct otp_info info;
    int fd, type, ret = PP_ERR;

    fd = open(FLASH_DEVICE, O_RDONLY);
    if (fd < 0) goto bail;
    type = MTD_OTP_USER;
    if (ioctl(fd, OTPSELECT, &type) < 0) goto bail;
    memset(&info, 0, sizeof(info));
    info.start = 0;
    info.length = 8;
    if (ioctl(fd, OTPLOCK, &info) < 0) goto bail;
    ret = PP_SUC;

 bail:
    if (fd != -1) close(fd);
    return ret;
}

#endif /* PP_FEAT_CREATE_FLASHID */

static char *
get_flash_id(int type)
{
    char rawbuf[PP_HAL_COMMON_MAX_FLASHID_LEN / 2];
    char buf[PP_HAL_COMMON_MAX_FLASHID_LEN + 1];
    char * ret = NULL;
    int fd, i, n;

    fd = open(FLASH_DEVICE, O_RDONLY);
    if (fd < 0) goto bail;
    if (ioctl(fd, OTPSELECT, &type) < 0) goto bail;
    if ((n = read(fd, rawbuf, PP_HAL_COMMON_MAX_FLASHID_LEN / 2)) < 0) goto bail;
    for (i = 0; i < n; ++i) {
	sprintf(&buf[i*2], "%02x", rawbuf[i]);
    }
    ret = strdup(buf);
    
 bail:
    if (fd != -1) close(fd);
    return ret;
}
