#ifndef _PP_HAL_KX2_H
#define _PP_HAL_KX2_H

#define PP_HAL_KX2_DUAL_POWER_1 0x1
#define PP_HAL_KX2_DUAL_POWER_2 0x2

#define PP_HAL_KX2_USER_LED_ON 0x1
#define PP_HAL_KX2_USER_LED_OFF 0x2
#define PP_HAL_KX2_USER_LED_OLD_VALUE 0x3

int pp_hal_kx2_set_user_led(u_char user1, u_char user2, u_char user3, u_char user4);
int pp_hal_kx2_set_power_led(int blue, int red);
int pp_hal_kx2_get_power_status(void);
int pp_hal_kx2_set_user_led_by_video_link(int videolink /* starts from 0 */, u_char status);


/*
   --------------------------------------------------------------------
    @brief              Beep KX2 buzzer for duration
    @param            duration in seconds
    @return             1 (SUCCESS)
    --------------------------------------------------------------------
*/
int pp_hal_kx2_beep(unsigned int duration);

/*
   --------------------------------------------------------------------
    @brief              Power supply change notifier
    @param             none
    @return             0 (SUCCESS)
    --------------------------------------------------------------------
*/
int pp_hal_power_supply_monitor_thread_start(void);


typedef enum {
    PP_HAL_KX2_GBIT_LAN1 = 0,
    PP_HAL_KX2_GBIT_LAN2 = 1
} pp_hal_kx2_gbit_if_t;

void pp_hal_kx2_gbit_set_interface(pp_hal_kx2_gbit_if_t gbit_if_intf);

#endif /* _PP_HAL_KX2_H */
