/**
 * \file ipmi_oem_rackable.h
 *
 * Description: OEM commands for Rackable Roamer
 *
 * (c) 2006 Raritan Computer Inc., Ingo van Lil <ingo.lil@raritan.com>
 */

#include <pp/ipmi.h>

#ifndef IPMI_OEM_RACKABLE_H
#define IPMI_OEM_RACKABLE_H

#define IPMI_NETFN_OEM_RACKABLE             0x3a

#define BMC_OEM_RACKABLE_COLOR_LED_IDENTIFY 0x01
#define BMC_OEM_RACKABLE_LCD_SET_SLOT       0x10
#define BMC_OEM_RACKABLE_LCD_GET_SLOT       0x11
#define BMC_OEM_RACKABLE_LCD_SET_STATE      0x12
#define BMC_OEM_RACKABLE_LCD_GET_STATE      0x13

int ipmi_oem_rackable_main(struct ipmi_intf *, int, pp_ipmi_parameter_t *, pp_ipmi_return_t *ret, int *error);

#endif /* !IPMI_OEM_RACKABLE_H */
