#include <stdio.h>
#ifndef WIN32
#include <unistd.h>
#endif
#include <memory.h>
#include <malloc.h>
#include <string.h>

#include <config.h>
#include <ipmi_params.h>

#include <ipmitool/ipmi_print.h>

t_ipmitool_commandline* init_cmdline(void) {
    t_ipmitool_commandline *ret = malloc(sizeof(t_ipmitool_commandline));
    
    if (!ret) return NULL;
    memset(ret, 0, sizeof(t_ipmitool_commandline));
    
    return ret;
}

void cleanup_cmdline(t_ipmitool_commandline *cmdline) {
    int i;
    
    if (!cmdline) return;
    
    for (i = 0; i < MAX_NO_IPMI_ARGV; i++) {
    	if (cmdline->argv[i]) {
    	    free(cmdline->argv[i]);
    	}
    }
    
    free(cmdline);
}

void cmdline_add(t_ipmitool_commandline *cmdline, char *command) {
    if (!cmdline || cmdline->argc >= MAX_NO_IPMI_ARGV) {
    	return;
    }
    
    if (*command == '\"') {
    	command++;
    }
    if (command[strlen(command) - 1] == '\"') {
    	command[strlen(command) - 1] = '\0';
    }
    
    D("Adding at pos %d: %s.\n", cmdline->argc, command);
    
    cmdline->argv[cmdline->argc++] = strdup(command);
}

int cmdline_add_command(t_ipmitool_commandline *cmdline, char *command_in) {
    int ret = -1;
    char *command;
    char *command_first;
    int in_quotes = 0;
    
    if (!command_in) {
    	// no comamndline to add
    	return 0;
    }
    
    command = strdup(command_in);
    command_first = command;
    
    if (command) {
    	char *start = command;
    	
    	while(*command) {
    	    if (*command == '\"') {
    	    	in_quotes = !in_quotes;
    	    }
    	    if (*command == ' ' && !in_quotes) {
    	    	*command = '\0';
    	    	cmdline_add(cmdline, start);
    	    	start = command + 1;
    	    }
    	    command++;
    	}
    	
    	if (start != command) {
    	    cmdline_add(cmdline, start);
    	}
    	
    	ret = 0;
    	free(command_first);
    }
    
    return ret;
}

t_ipmitool_commandline* get_cmdline(pp_ipmi_parameter_t *params) {
    t_ipmitool_commandline *ret;
    
    ret = init_cmdline();
    if (!ret) return NULL;

    if (params && params->is_cmdline) {
    	cmdline_add_command(ret, params->data.cmdline);
    }
    
    return ret;
}

